/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.alert.policy.transform;

import com.dianping.cat.home.alert.policy.IEntity;
import com.dianping.cat.home.alert.policy.IVisitor;
import com.dianping.cat.home.alert.policy.entity.AlertPolicy;
import com.dianping.cat.home.alert.policy.entity.Group;
import com.dianping.cat.home.alert.policy.entity.Level;
import com.dianping.cat.home.alert.policy.entity.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXmlBuilder
implements IVisitor {
    private IVisitor m_visitor = this;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultXmlBuilder() {
        this(false);
    }

    public DefaultXmlBuilder(boolean compact) {
        this(compact, new StringBuilder(4096));
    }

    public DefaultXmlBuilder(boolean compact, StringBuilder sb) {
        this.m_compact = compact;
        this.m_sb = sb;
        this.m_sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
    }

    public String buildXml(IEntity<?> entity) {
        entity.accept(this.m_visitor);
        return this.m_sb.toString();
    }

    protected void endTag(String name) {
        --this.m_level;
        this.indent();
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected String escape(Object value) {
        return this.escape(value, false);
    }

    protected String escape(Object value, boolean text) {
        if (value == null) {
            return null;
        }
        String str = value.toString();
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 16);
        block6: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (!text) {
                        sb.append("&quot;");
                        continue block6;
                    }
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void startTag(String name) {
        this.startTag(name, false, null, new Object[0]);
    }

    protected void startTag(String name, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, null, closed, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, null, false, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Object text, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                this.m_sb.append(' ').append(e.getKey()).append("=\"").append(this.escape((Object)e.getValue())).append('\"');
            }
        }
        if (text != null && closed) {
            this.m_sb.append('>');
            this.m_sb.append(this.escape(text, true));
            this.m_sb.append("</").append(name).append(">\r\n");
        } else {
            if (closed) {
                this.m_sb.append('/');
            } else {
                ++this.m_level;
            }
            this.m_sb.append(">\r\n");
        }
    }

    public void visitAlertPolicy(AlertPolicy alertPolicy) {
        this.startTag("alert-policy", null, new Object[0]);
        if (!alertPolicy.getTypes().isEmpty()) {
            for (Type type : alertPolicy.getTypes().values()) {
                type.accept(this.m_visitor);
            }
        }
        this.endTag("alert-policy");
    }

    public void visitGroup(Group group) {
        this.startTag("group", null, new Object[]{"id", group.getId()});
        if (!group.getLevels().isEmpty()) {
            for (Level level : group.getLevels().values()) {
                level.accept(this.m_visitor);
            }
        }
        this.endTag("group");
    }

    public void visitLevel(Level level) {
        this.startTag("level", true, null, new Object[]{"id", level.getId(), "send", level.getSend(), "suspendMinute", level.getSuspendMinute(), "recoverMinute", level.getRecoverMinute()});
    }

    public void visitType(Type type) {
        this.startTag("type", null, new Object[]{"id", type.getId()});
        if (!type.getGroups().isEmpty()) {
            for (Group group : type.getGroups().values()) {
                group.accept(this.m_visitor);
            }
        }
        this.endTag("type");
    }
}

