/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.app.entity;

import com.dianping.cat.home.app.BaseEntity;
import com.dianping.cat.home.app.IVisitor;
import com.dianping.cat.home.app.entity.Command;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppReport
extends BaseEntity<AppReport> {
    private String m_id;
    private Date m_startTime;
    private Date m_endTime;
    private Map<Integer, Command> m_commands = new LinkedHashMap();

    public AppReport() {
    }

    public AppReport(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitAppReport(this);
    }

    public AppReport addCommand(Command command) {
        this.m_commands.put(command.getId(), command);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AppReport) {
            AppReport _o = (AppReport)obj;
            return this.equals((Object)this.m_id, (Object)_o.getId());
        }
        return false;
    }

    public Command findCommand(int id) {
        return (Command)this.m_commands.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command findOrCreateCommand(int id) {
        Command command = (Command)this.m_commands.get(id);
        if (command == null) {
            Map map = this.m_commands;
            synchronized (map) {
                command = (Command)this.m_commands.get(id);
                if (command == null) {
                    command = new Command(id);
                    this.m_commands.put(id, command);
                }
            }
        }
        return command;
    }

    public Map<Integer, Command> getCommands() {
        return this.m_commands;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public String getId() {
        return this.m_id;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(AppReport other) {
        this.assertAttributeEquals((Object)other, "app-report", "id", (Object)this.m_id, (Object)other.getId());
        if (other.getStartTime() != null) {
            this.m_startTime = other.getStartTime();
        }
        if (other.getEndTime() != null) {
            this.m_endTime = other.getEndTime();
        }
    }

    public Command removeCommand(int id) {
        return (Command)this.m_commands.remove(id);
    }

    public AppReport setEndTime(Date endTime) {
        this.m_endTime = endTime;
        return this;
    }

    public AppReport setId(String id) {
        this.m_id = id;
        return this;
    }

    public AppReport setStartTime(Date startTime) {
        this.m_startTime = startTime;
        return this;
    }
}

