/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.app.entity;

import com.dianping.cat.home.app.BaseEntity;
import com.dianping.cat.home.app.IVisitor;
import com.dianping.cat.home.app.entity.Code;
import com.dianping.cat.home.app.entity.Transaction;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command
extends BaseEntity<Command> {
    private int m_id;
    private String m_name;
    private long m_count;
    private double m_sum;
    private double m_avg;
    private long m_errors;
    private double m_successRatio;
    private long m_requestSum;
    private double m_requestAvg;
    private long m_responseSum;
    private double m_responseAvg;
    private Transaction m_transaction;
    private Map<String, Code> m_codes = new LinkedHashMap();

    public Command() {
    }

    public Command(int id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitCommand(this);
    }

    public Command addCode(Code code) {
        this.m_codes.put(code.getId(), code);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Command) {
            Command _o = (Command)obj;
            return this.m_id == _o.getId();
        }
        return false;
    }

    public Code findCode(String id) {
        return (Code)this.m_codes.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Code findOrCreateCode(String id) {
        Code code = (Code)this.m_codes.get(id);
        if (code == null) {
            Map map = this.m_codes;
            synchronized (map) {
                code = (Code)this.m_codes.get(id);
                if (code == null) {
                    code = new Code(id);
                    this.m_codes.put(id, code);
                }
            }
        }
        return code;
    }

    public double getAvg() {
        return this.m_avg;
    }

    public Map<String, Code> getCodes() {
        return this.m_codes;
    }

    public long getCount() {
        return this.m_count;
    }

    public long getErrors() {
        return this.m_errors;
    }

    public int getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public double getRequestAvg() {
        return this.m_requestAvg;
    }

    public long getRequestSum() {
        return this.m_requestSum;
    }

    public double getResponseAvg() {
        return this.m_responseAvg;
    }

    public long getResponseSum() {
        return this.m_responseSum;
    }

    public double getSuccessRatio() {
        return this.m_successRatio;
    }

    public double getSum() {
        return this.m_sum;
    }

    public Transaction getTransaction() {
        return this.m_transaction;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + this.m_id;
        return hash;
    }

    public Command incCount() {
        ++this.m_count;
        return this;
    }

    public Command incCount(long count) {
        this.m_count += count;
        return this;
    }

    public Command incErrors() {
        ++this.m_errors;
        return this;
    }

    public Command incErrors(long errors) {
        this.m_errors += errors;
        return this;
    }

    public Command incRequestSum() {
        ++this.m_requestSum;
        return this;
    }

    public Command incRequestSum(long requestSum) {
        this.m_requestSum += requestSum;
        return this;
    }

    public Command incResponseSum() {
        ++this.m_responseSum;
        return this;
    }

    public Command incResponseSum(long responseSum) {
        this.m_responseSum += responseSum;
        return this;
    }

    public Command incSum() {
        this.m_sum += 1.0;
        return this;
    }

    public Command incSum(double sum) {
        this.m_sum += sum;
        return this;
    }

    public void mergeAttributes(Command other) {
        this.assertAttributeEquals((Object)other, "command", "id", (Object)this.m_id, (Object)other.getId());
        if (other.getName() != null) {
            this.m_name = other.getName();
        }
        this.m_count = other.getCount();
        this.m_sum = other.getSum();
        this.m_avg = other.getAvg();
        this.m_errors = other.getErrors();
        this.m_successRatio = other.getSuccessRatio();
        this.m_requestSum = other.getRequestSum();
        this.m_requestAvg = other.getRequestAvg();
        this.m_responseSum = other.getResponseSum();
        this.m_responseAvg = other.getResponseAvg();
    }

    public Code removeCode(String id) {
        return (Code)this.m_codes.remove(id);
    }

    public Command setAvg(double avg) {
        this.m_avg = avg;
        return this;
    }

    public Command setCount(long count) {
        this.m_count = count;
        return this;
    }

    public Command setErrors(long errors) {
        this.m_errors = errors;
        return this;
    }

    public Command setId(int id) {
        this.m_id = id;
        return this;
    }

    public Command setName(String name) {
        this.m_name = name;
        return this;
    }

    public Command setRequestAvg(double requestAvg) {
        this.m_requestAvg = requestAvg;
        return this;
    }

    public Command setRequestSum(long requestSum) {
        this.m_requestSum = requestSum;
        return this;
    }

    public Command setResponseAvg(double responseAvg) {
        this.m_responseAvg = responseAvg;
        return this;
    }

    public Command setResponseSum(long responseSum) {
        this.m_responseSum = responseSum;
        return this;
    }

    public Command setSuccessRatio(double successRatio) {
        this.m_successRatio = successRatio;
        return this;
    }

    public Command setSum(double sum) {
        this.m_sum = sum;
        return this;
    }

    public Command setTransaction(Transaction transaction) {
        this.m_transaction = transaction;
        return this;
    }
}

