/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.app.transform;

import com.dianping.cat.home.app.IEntity;
import com.dianping.cat.home.app.IVisitor;
import com.dianping.cat.home.app.entity.AppReport;
import com.dianping.cat.home.app.entity.Code;
import com.dianping.cat.home.app.entity.Command;
import com.dianping.cat.home.app.entity.Transaction;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private AppReport m_appReport;

    public DefaultMerger() {
    }

    public DefaultMerger(AppReport appReport) {
        this.m_appReport = appReport;
        this.m_objs.push(appReport);
    }

    public AppReport getAppReport() {
        return this.m_appReport;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeAppReport(AppReport to, AppReport from) {
        to.mergeAttributes(from);
    }

    protected void mergeCode(Code to, Code from) {
        to.mergeAttributes(from);
    }

    protected void mergeCommand(Command to, Command from) {
        to.mergeAttributes(from);
    }

    protected void mergeTransaction(Transaction to, Transaction from) {
        to.mergeAttributes(from);
    }

    public void visitAppReport(AppReport from) {
        AppReport to = (AppReport)this.m_objs.peek();
        this.mergeAppReport(to, from);
        this.visitAppReportChildren(to, from);
    }

    protected void visitAppReportChildren(AppReport to, AppReport from) {
        for (Command source : from.getCommands().values()) {
            Command target = to.findCommand(source.getId());
            if (target == null) {
                target = new Command(source.getId());
                to.addCommand(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitCode(Code from) {
        Code to = (Code)this.m_objs.peek();
        this.mergeCode(to, from);
        this.visitCodeChildren(to, from);
    }

    protected void visitCodeChildren(Code to, Code from) {
    }

    public void visitCommand(Command from) {
        Command to = (Command)this.m_objs.peek();
        this.mergeCommand(to, from);
        this.visitCommandChildren(to, from);
    }

    protected void visitCommandChildren(Command to, Command from) {
        if (from.getTransaction() != null) {
            Transaction target = to.getTransaction();
            if (target == null) {
                Transaction source = from.getTransaction();
                target = new Transaction(source.getUrl());
                to.setTransaction(target);
            }
            this.m_objs.push(target);
            from.getTransaction().accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (Transaction source : from.getCodes().values()) {
            Code target = to.findCode(source.getId());
            if (target == null) {
                target = new Code(source.getId());
                to.addCode(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitTransaction(Transaction from) {
        Transaction to = (Transaction)this.m_objs.peek();
        this.mergeTransaction(to, from);
        this.visitTransactionChildren(to, from);
    }

    protected void visitTransactionChildren(Transaction to, Transaction from) {
    }
}

