/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.app.transform;

import com.dianping.cat.home.app.IVisitor;
import com.dianping.cat.home.app.entity.AppReport;
import com.dianping.cat.home.app.entity.Code;
import com.dianping.cat.home.app.entity.Command;
import com.dianping.cat.home.app.entity.Transaction;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private DataOutputStream m_out;

    public DefaultNativeBuilder(OutputStream out) {
        this(out, null);
    }

    public DefaultNativeBuilder(OutputStream out, IVisitor visitor) {
        this.m_out = new DataOutputStream(out);
        this.m_visitor = visitor == null ? this : visitor;
    }

    public static byte[] build(AppReport appReport) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DefaultNativeBuilder.build((AppReport)appReport, (OutputStream)out);
        return out.toByteArray();
    }

    public static void build(AppReport appReport, OutputStream out) {
        appReport.accept((IVisitor)new DefaultNativeBuilder(out));
    }

    public void visitAppReport(AppReport appReport) {
        this.writeTag(63, 0);
        if (appReport.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(appReport.getId());
        }
        if (appReport.getStartTime() != null) {
            this.writeTag(2, 1);
            this.writeDate(appReport.getStartTime());
        }
        if (appReport.getEndTime() != null) {
            this.writeTag(3, 1);
            this.writeDate(appReport.getEndTime());
        }
        if (!appReport.getCommands().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(appReport.getCommands().size());
            for (Command command : appReport.getCommands().values()) {
                command.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitCode(Code code) {
        if (code.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(code.getId());
        }
        this.writeTag(2, 0);
        this.writeLong(code.getCount());
        this.writeTag(3, 0);
        this.writeDouble(code.getSum());
        this.writeTag(4, 0);
        this.writeDouble(code.getAvg());
        this.writeTag(5, 0);
        this.writeLong(code.getErrors());
        this.writeTag(6, 0);
        this.writeDouble(code.getSuccessRatio());
        this.writeTag(63, 3);
    }

    public void visitCommand(Command command) {
        this.writeTag(1, 0);
        this.writeInt(command.getId());
        if (command.getName() != null) {
            this.writeTag(2, 1);
            this.writeString(command.getName());
        }
        this.writeTag(3, 0);
        this.writeLong(command.getCount());
        this.writeTag(4, 0);
        this.writeDouble(command.getSum());
        this.writeTag(5, 0);
        this.writeDouble(command.getAvg());
        this.writeTag(6, 0);
        this.writeLong(command.getErrors());
        this.writeTag(7, 0);
        this.writeDouble(command.getSuccessRatio());
        this.writeTag(8, 0);
        this.writeLong(command.getRequestSum());
        this.writeTag(9, 0);
        this.writeDouble(command.getRequestAvg());
        this.writeTag(10, 0);
        this.writeLong(command.getResponseSum());
        this.writeTag(11, 0);
        this.writeDouble(command.getResponseAvg());
        if (command.getTransaction() != null) {
            this.writeTag(33, 1);
            command.getTransaction().accept(this.m_visitor);
        }
        if (!command.getCodes().isEmpty()) {
            this.writeTag(34, 2);
            this.writeInt(command.getCodes().size());
            for (Code code : command.getCodes().values()) {
                code.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitTransaction(Transaction transaction) {
        if (transaction.getUrl() != null) {
            this.writeTag(1, 1);
            this.writeString(transaction.getUrl());
        }
        this.writeTag(2, 0);
        this.writeLong(transaction.getCount());
        this.writeTag(3, 0);
        this.writeDouble(transaction.getAvg());
        this.writeTag(63, 3);
    }

    private void writeDate(Date value) {
        try {
            this.writeVarint(value.getTime());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDouble(double value) {
        try {
            this.writeVarint(Double.doubleToLongBits(value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeInt(int value) {
        try {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeLong(long value) {
        try {
            this.writeVarint(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String value) {
        try {
            this.m_out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(int field, int type) {
        try {
            this.m_out.writeByte((field << 2) + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVarint(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.m_out.writeByte((byte)value);
                return;
            }
            this.m_out.writeByte((byte)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }
}

