/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.app.transform;

import com.dianping.cat.home.app.IVisitor;
import com.dianping.cat.home.app.entity.AppReport;
import com.dianping.cat.home.app.entity.Code;
import com.dianping.cat.home.app.entity.Command;
import com.dianping.cat.home.app.entity.Transaction;
import com.dianping.cat.home.app.transform.DefaultLinker;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeParser
implements IVisitor {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DataInputStream m_in;

    public DefaultNativeParser(InputStream in) {
        this.m_in = new DataInputStream(in);
    }

    public static AppReport parse(byte[] data) {
        return DefaultNativeParser.parse((InputStream)new ByteArrayInputStream(data));
    }

    public static AppReport parse(InputStream in) {
        AppReport appReport;
        DefaultNativeParser parser;
        block2: {
            parser = new DefaultNativeParser(in);
            appReport = new AppReport();
            try {
                appReport.accept((IVisitor)parser);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
        parser.m_linker.finish();
        return appReport;
    }

    public void visitAppReport(AppReport appReport) {
        byte tag = this.readTag();
        if (tag != -4) {
            throw new RuntimeException(String.format("Malformed payload, expected: %s, but was: %s!", -4, tag));
        }
        while ((tag = this.readTag()) != -1) {
            this.visitAppReportChildren(appReport, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitAppReportChildren(AppReport appReport, int _field, int _type) {
        switch (_field) {
            case 1: {
                appReport.setId(this.readString());
                break;
            }
            case 2: {
                appReport.setStartTime(this.readDate());
                break;
            }
            case 3: {
                appReport.setEndTime(this.readDate());
                break;
            }
            case 33: {
                if (_type == 1) {
                    Command commands = new Command();
                    this.visitCommand(commands);
                    this.m_linker.onCommand(appReport, commands);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Command commands = new Command();
                    this.visitCommand(commands);
                    this.m_linker.onCommand(appReport, commands);
                }
                break;
            }
        }
    }

    public void visitCode(Code code) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitCodeChildren(code, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitCodeChildren(Code code, int _field, int _type) {
        switch (_field) {
            case 1: {
                code.setId(this.readString());
                break;
            }
            case 2: {
                code.setCount(this.readLong());
                break;
            }
            case 3: {
                code.setSum(this.readDouble());
                break;
            }
            case 4: {
                code.setAvg(this.readDouble());
                break;
            }
            case 5: {
                code.setErrors(this.readLong());
                break;
            }
            case 6: {
                code.setSuccessRatio(this.readDouble());
            }
        }
    }

    public void visitCommand(Command command) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitCommandChildren(command, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitCommandChildren(Command command, int _field, int _type) {
        switch (_field) {
            case 1: {
                command.setId(this.readInt());
                break;
            }
            case 2: {
                command.setName(this.readString());
                break;
            }
            case 3: {
                command.setCount(this.readLong());
                break;
            }
            case 4: {
                command.setSum(this.readDouble());
                break;
            }
            case 5: {
                command.setAvg(this.readDouble());
                break;
            }
            case 6: {
                command.setErrors(this.readLong());
                break;
            }
            case 7: {
                command.setSuccessRatio(this.readDouble());
                break;
            }
            case 8: {
                command.setRequestSum(this.readLong());
                break;
            }
            case 9: {
                command.setRequestAvg(this.readDouble());
                break;
            }
            case 10: {
                command.setResponseSum(this.readLong());
                break;
            }
            case 11: {
                command.setResponseAvg(this.readDouble());
                break;
            }
            case 33: {
                Transaction transaction = new Transaction();
                this.visitTransaction(transaction);
                this.m_linker.onTransaction(command, transaction);
                break;
            }
            case 34: {
                if (_type == 1) {
                    Code codes = new Code();
                    this.visitCode(codes);
                    this.m_linker.onCode(command, codes);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Code codes = new Code();
                    this.visitCode(codes);
                    this.m_linker.onCode(command, codes);
                }
                break;
            }
        }
    }

    public void visitTransaction(Transaction transaction) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitTransactionChildren(transaction, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitTransactionChildren(Transaction transaction, int _field, int _type) {
        switch (_field) {
            case 1: {
                transaction.setUrl(this.readString());
                break;
            }
            case 2: {
                transaction.setCount(this.readLong());
                break;
            }
            case 3: {
                transaction.setAvg(this.readDouble());
            }
        }
    }

    private Date readDate() {
        try {
            return new Date(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private double readDouble() {
        try {
            return Double.longBitsToDouble(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readInt() {
        try {
            return (int)this.readVarint(32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long readLong() {
        try {
            return this.readVarint(64);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readString() {
        try {
            return this.m_in.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte readTag() {
        try {
            return this.m_in.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected long readVarint(int length) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < length; shift += 7) {
            byte b = this.m_in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("Malformed variable int " + length + "!");
    }
}

