/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.app.transform;

import com.dianping.cat.home.app.entity.AppReport;
import com.dianping.cat.home.app.entity.Code;
import com.dianping.cat.home.app.entity.Command;
import com.dianping.cat.home.app.entity.Transaction;
import com.dianping.cat.home.app.transform.IMaker;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxMaker
implements IMaker<Attributes> {
    public AppReport buildAppReport(Attributes attributes) {
        String id = attributes.getValue("id");
        String startTime = attributes.getValue("start-time");
        String endTime = attributes.getValue("end-time");
        AppReport appReport = new AppReport(id);
        if (startTime != null) {
            appReport.setStartTime(this.toDate(startTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (endTime != null) {
            appReport.setEndTime(this.toDate(endTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        return appReport;
    }

    public Code buildCode(Attributes attributes) {
        String id = attributes.getValue("id");
        String count = attributes.getValue("count");
        String sum = attributes.getValue("sum");
        String avg = attributes.getValue("avg");
        String errors = attributes.getValue("errors");
        String successRatio = attributes.getValue("successRatio");
        Code code = new Code(id);
        if (count != null) {
            code.setCount(((Long)this.convert(Long.class, count, (Object)0L)).longValue());
        }
        if (sum != null) {
            code.setSum(this.toNumber(sum, "0.00", (Number)0).doubleValue());
        }
        if (avg != null) {
            code.setAvg(this.toNumber(avg, "0.00", (Number)0).doubleValue());
        }
        if (errors != null) {
            code.setErrors(((Long)this.convert(Long.class, errors, (Object)0L)).longValue());
        }
        if (successRatio != null) {
            code.setSuccessRatio(this.toNumber(successRatio, "0.000", (Number)0).doubleValue());
        }
        return code;
    }

    public Command buildCommand(Attributes attributes) {
        String id = attributes.getValue("id");
        String name = attributes.getValue("name");
        String count = attributes.getValue("count");
        String sum = attributes.getValue("sum");
        String avg = attributes.getValue("avg");
        String errors = attributes.getValue("errors");
        String successRatio = attributes.getValue("successRatio");
        String requestSum = attributes.getValue("requestSum");
        String requestAvg = attributes.getValue("requestAvg");
        String responseSum = attributes.getValue("responseSum");
        String responseAvg = attributes.getValue("responseAvg");
        Command command = new Command(id == null ? 0 : (Integer)this.convert(Integer.class, id, (Object)0));
        if (name != null) {
            command.setName(name);
        }
        if (count != null) {
            command.setCount(((Long)this.convert(Long.class, count, (Object)0L)).longValue());
        }
        if (sum != null) {
            command.setSum(this.toNumber(sum, "0.00", (Number)0).doubleValue());
        }
        if (avg != null) {
            command.setAvg(this.toNumber(avg, "0.00", (Number)0).doubleValue());
        }
        if (errors != null) {
            command.setErrors(((Long)this.convert(Long.class, errors, (Object)0L)).longValue());
        }
        if (successRatio != null) {
            command.setSuccessRatio(this.toNumber(successRatio, "0.000", (Number)0).doubleValue());
        }
        if (requestSum != null) {
            command.setRequestSum(((Long)this.convert(Long.class, requestSum, (Object)0L)).longValue());
        }
        if (requestAvg != null) {
            command.setRequestAvg(this.toNumber(requestAvg, "0.00", (Number)0).doubleValue());
        }
        if (responseSum != null) {
            command.setResponseSum(((Long)this.convert(Long.class, responseSum, (Object)0L)).longValue());
        }
        if (responseAvg != null) {
            command.setResponseAvg(this.toNumber(responseAvg, "0.00", (Number)0).doubleValue());
        }
        return command;
    }

    public Transaction buildTransaction(Attributes attributes) {
        String url = attributes.getValue("url");
        String count = attributes.getValue("count");
        String avg = attributes.getValue("avg");
        Transaction transaction = new Transaction(url);
        if (count != null) {
            transaction.setCount(((Long)this.convert(Long.class, count, (Object)0L)).longValue());
        }
        if (avg != null) {
            transaction.setAvg(this.toNumber(avg, "0.00", (Number)0).doubleValue());
        }
        return transaction;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected Date toDate(String str, String format, Date defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }

    protected Number toNumber(String str, String format, Number defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new DecimalFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse number(%s) in format(%s)!", str, format), e);
        }
    }
}

