/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.bug.config.entity;

import com.dianping.cat.home.bug.config.BaseEntity;
import com.dianping.cat.home.bug.config.IVisitor;
import com.dianping.cat.home.bug.config.entity.Domain;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugConfig
extends BaseEntity<BugConfig> {
    private List<String> m_exceptions = new ArrayList();
    private Map<String, Domain> m_domains = new LinkedHashMap();

    public void accept(IVisitor visitor) {
        visitor.visitBugConfig(this);
    }

    public BugConfig addDomain(Domain domain) {
        this.m_domains.put(domain.getId(), domain);
        return this;
    }

    public BugConfig addException(String exception) {
        this.m_exceptions.add(exception);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BugConfig) {
            BugConfig _o = (BugConfig)obj;
            if (!this.equals((Object)this.m_exceptions, (Object)_o.getExceptions())) {
                return false;
            }
            return this.equals((Object)this.m_domains, (Object)_o.getDomains());
        }
        return false;
    }

    public Domain findDomain(String id) {
        return (Domain)this.m_domains.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain findOrCreateDomain(String id) {
        Domain domain = (Domain)this.m_domains.get(id);
        if (domain == null) {
            Map map = this.m_domains;
            synchronized (map) {
                domain = (Domain)this.m_domains.get(id);
                if (domain == null) {
                    domain = new Domain(id);
                    this.m_domains.put(id, domain);
                }
            }
        }
        return domain;
    }

    public Map<String, Domain> getDomains() {
        return this.m_domains;
    }

    public List<String> getExceptions() {
        return this.m_exceptions;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_exceptions == null ? 0 : this.m_exceptions.hashCode());
        hash = hash * 31 + (this.m_domains == null ? 0 : this.m_domains.hashCode());
        return hash;
    }

    public void mergeAttributes(BugConfig other) {
    }

    public Domain removeDomain(String id) {
        return (Domain)this.m_domains.remove(id);
    }
}

