/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.bug.entity;

import com.dianping.cat.home.bug.BaseEntity;
import com.dianping.cat.home.bug.IVisitor;
import com.dianping.cat.home.bug.entity.ExceptionItem;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain
extends BaseEntity<Domain> {
    private String m_id;
    private String m_problemUrl;
    private Map<String, ExceptionItem> m_exceptionItems = new LinkedHashMap();
    private String m_department;
    private String m_productLine;
    private String m_excpetion;

    public Domain() {
    }

    public Domain(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitDomain(this);
    }

    public Domain addExceptionItem(ExceptionItem exceptionItem) {
        this.m_exceptionItems.put(exceptionItem.getId(), exceptionItem);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Domain) {
            Domain _o = (Domain)obj;
            return this.equals((Object)this.m_id, (Object)_o.getId());
        }
        return false;
    }

    public ExceptionItem findExceptionItem(String id) {
        return (ExceptionItem)this.m_exceptionItems.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExceptionItem findOrCreateExceptionItem(String id) {
        ExceptionItem exceptionItem = (ExceptionItem)this.m_exceptionItems.get(id);
        if (exceptionItem == null) {
            Map map = this.m_exceptionItems;
            synchronized (map) {
                exceptionItem = (ExceptionItem)this.m_exceptionItems.get(id);
                if (exceptionItem == null) {
                    exceptionItem = new ExceptionItem(id);
                    this.m_exceptionItems.put(id, exceptionItem);
                }
            }
        }
        return exceptionItem;
    }

    public String getDepartment() {
        return this.m_department;
    }

    public Map<String, ExceptionItem> getExceptionItems() {
        return this.m_exceptionItems;
    }

    public String getExcpetion() {
        return this.m_excpetion;
    }

    public String getId() {
        return this.m_id;
    }

    public String getProblemUrl() {
        return this.m_problemUrl;
    }

    public String getProductLine() {
        return this.m_productLine;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Domain other) {
        this.assertAttributeEquals((Object)other, "domain", "id", (Object)this.m_id, (Object)other.getId());
        if (other.getDepartment() != null) {
            this.m_department = other.getDepartment();
        }
        if (other.getProductLine() != null) {
            this.m_productLine = other.getProductLine();
        }
    }

    public ExceptionItem removeExceptionItem(String id) {
        return (ExceptionItem)this.m_exceptionItems.remove(id);
    }

    public Domain setDepartment(String department) {
        this.m_department = department;
        return this;
    }

    public Domain setExcpetion(String excpetion) {
        this.m_excpetion = excpetion;
        return this;
    }

    public Domain setId(String id) {
        this.m_id = id;
        return this;
    }

    public Domain setProblemUrl(String problemUrl) {
        this.m_problemUrl = problemUrl;
        return this;
    }

    public Domain setProductLine(String productLine) {
        this.m_productLine = productLine;
        return this;
    }
}

