/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.bug.transform;

import com.dianping.cat.home.bug.IEntity;
import com.dianping.cat.home.bug.IVisitor;
import com.dianping.cat.home.bug.entity.BugReport;
import com.dianping.cat.home.bug.entity.Domain;
import com.dianping.cat.home.bug.entity.ExceptionItem;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private BugReport m_bugReport;

    public DefaultMerger() {
    }

    public DefaultMerger(BugReport bugReport) {
        this.m_bugReport = bugReport;
        this.m_objs.push(bugReport);
    }

    public BugReport getBugReport() {
        return this.m_bugReport;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeBugReport(BugReport to, BugReport from) {
        to.mergeAttributes(from);
    }

    protected void mergeDomain(Domain to, Domain from) {
        to.mergeAttributes(from);
        to.setProblemUrl(from.getProblemUrl());
        to.setExcpetion(from.getExcpetion());
    }

    protected void mergeExceptionItem(ExceptionItem to, ExceptionItem from) {
        to.mergeAttributes(from);
        to.getMessages().addAll(from.getMessages());
    }

    public void visitBugReport(BugReport from) {
        BugReport to = (BugReport)this.m_objs.peek();
        this.mergeBugReport(to, from);
        this.visitBugReportChildren(to, from);
    }

    protected void visitBugReportChildren(BugReport to, BugReport from) {
        for (Domain source : from.getDomains().values()) {
            Domain target = to.findDomain(source.getId());
            if (target == null) {
                target = new Domain(source.getId());
                to.addDomain(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitDomain(Domain from) {
        Domain to = (Domain)this.m_objs.peek();
        this.mergeDomain(to, from);
        this.visitDomainChildren(to, from);
    }

    protected void visitDomainChildren(Domain to, Domain from) {
        for (ExceptionItem source : from.getExceptionItems().values()) {
            ExceptionItem target = to.findExceptionItem(source.getId());
            if (target == null) {
                target = new ExceptionItem(source.getId());
                to.addExceptionItem(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitExceptionItem(ExceptionItem from) {
        ExceptionItem to = (ExceptionItem)this.m_objs.peek();
        this.mergeExceptionItem(to, from);
        this.visitExceptionItemChildren(to, from);
    }

    protected void visitExceptionItemChildren(ExceptionItem to, ExceptionItem from) {
    }
}

