/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.bug.transform;

import com.dianping.cat.home.bug.IVisitor;
import com.dianping.cat.home.bug.entity.BugReport;
import com.dianping.cat.home.bug.entity.Domain;
import com.dianping.cat.home.bug.entity.ExceptionItem;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private DataOutputStream m_out;

    public DefaultNativeBuilder(OutputStream out) {
        this(out, null);
    }

    public DefaultNativeBuilder(OutputStream out, IVisitor visitor) {
        this.m_out = new DataOutputStream(out);
        this.m_visitor = visitor == null ? this : visitor;
    }

    public static byte[] build(BugReport bugReport) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DefaultNativeBuilder.build((BugReport)bugReport, (OutputStream)out);
        return out.toByteArray();
    }

    public static void build(BugReport bugReport, OutputStream out) {
        bugReport.accept((IVisitor)new DefaultNativeBuilder(out));
    }

    public void visitBugReport(BugReport bugReport) {
        this.writeTag(63, 0);
        if (bugReport.getStartTime() != null) {
            this.writeTag(1, 1);
            this.writeDate(bugReport.getStartTime());
        }
        if (bugReport.getDomain() != null) {
            this.writeTag(2, 1);
            this.writeString(bugReport.getDomain());
        }
        if (bugReport.getEndTime() != null) {
            this.writeTag(3, 1);
            this.writeDate(bugReport.getEndTime());
        }
        if (!bugReport.getDomains().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(bugReport.getDomains().size());
            for (Domain domain : bugReport.getDomains().values()) {
                domain.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitDomain(Domain domain) {
        if (domain.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(domain.getId());
        }
        if (domain.getProblemUrl() != null) {
            this.writeTag(2, 1);
            this.writeString(domain.getProblemUrl());
        }
        if (domain.getDepartment() != null) {
            this.writeTag(3, 1);
            this.writeString(domain.getDepartment());
        }
        if (domain.getProductLine() != null) {
            this.writeTag(4, 1);
            this.writeString(domain.getProductLine());
        }
        if (domain.getExcpetion() != null) {
            this.writeTag(5, 1);
            this.writeString(domain.getExcpetion());
        }
        if (!domain.getExceptionItems().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(domain.getExceptionItems().size());
            for (ExceptionItem exceptionItem : domain.getExceptionItems().values()) {
                exceptionItem.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitExceptionItem(ExceptionItem exceptionItem) {
        if (exceptionItem.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(exceptionItem.getId());
        }
        this.writeTag(2, 0);
        this.writeInt(exceptionItem.getCount());
        if (!exceptionItem.getMessages().isEmpty()) {
            this.writeTag(3, 2);
            this.writeInt(exceptionItem.getMessages().size());
            for (String message : exceptionItem.getMessages()) {
                this.writeString(message);
            }
        }
        this.writeTag(63, 3);
    }

    private void writeDate(Date value) {
        try {
            this.writeVarint(value.getTime());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeInt(int value) {
        try {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String value) {
        try {
            this.m_out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(int field, int type) {
        try {
            this.m_out.writeByte((field << 2) + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVarint(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.m_out.writeByte((byte)value);
                return;
            }
            this.m_out.writeByte((byte)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }
}

