/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.bug.transform;

import com.dianping.cat.home.bug.IVisitor;
import com.dianping.cat.home.bug.entity.BugReport;
import com.dianping.cat.home.bug.entity.Domain;
import com.dianping.cat.home.bug.entity.ExceptionItem;
import com.dianping.cat.home.bug.transform.DefaultLinker;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeParser
implements IVisitor {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DataInputStream m_in;

    public DefaultNativeParser(InputStream in) {
        this.m_in = new DataInputStream(in);
    }

    public static BugReport parse(byte[] data) {
        return DefaultNativeParser.parse((InputStream)new ByteArrayInputStream(data));
    }

    public static BugReport parse(InputStream in) {
        BugReport bugReport;
        DefaultNativeParser parser;
        block2: {
            parser = new DefaultNativeParser(in);
            bugReport = new BugReport();
            try {
                bugReport.accept((IVisitor)parser);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
        parser.m_linker.finish();
        return bugReport;
    }

    public void visitBugReport(BugReport bugReport) {
        byte tag = this.readTag();
        if (tag != -4) {
            throw new RuntimeException(String.format("Malformed payload, expected: %s, but was: %s!", -4, tag));
        }
        while ((tag = this.readTag()) != -1) {
            this.visitBugReportChildren(bugReport, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitBugReportChildren(BugReport bugReport, int _field, int _type) {
        switch (_field) {
            case 1: {
                bugReport.setStartTime(this.readDate());
                break;
            }
            case 2: {
                bugReport.setDomain(this.readString());
                break;
            }
            case 3: {
                bugReport.setEndTime(this.readDate());
                break;
            }
            case 33: {
                if (_type == 1) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(bugReport, domains);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(bugReport, domains);
                }
                break;
            }
        }
    }

    public void visitDomain(Domain domain) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitDomainChildren(domain, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitDomainChildren(Domain domain, int _field, int _type) {
        switch (_field) {
            case 1: {
                domain.setId(this.readString());
                break;
            }
            case 2: {
                domain.setProblemUrl(this.readString());
                break;
            }
            case 3: {
                domain.setDepartment(this.readString());
                break;
            }
            case 4: {
                domain.setProductLine(this.readString());
                break;
            }
            case 5: {
                domain.setExcpetion(this.readString());
                break;
            }
            case 33: {
                if (_type == 1) {
                    ExceptionItem exceptionItems = new ExceptionItem();
                    this.visitExceptionItem(exceptionItems);
                    this.m_linker.onExceptionItem(domain, exceptionItems);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    ExceptionItem exceptionItems = new ExceptionItem();
                    this.visitExceptionItem(exceptionItems);
                    this.m_linker.onExceptionItem(domain, exceptionItems);
                }
                break;
            }
        }
    }

    public void visitExceptionItem(ExceptionItem exceptionItem) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitExceptionItemChildren(exceptionItem, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitExceptionItemChildren(ExceptionItem exceptionItem, int _field, int _type) {
        switch (_field) {
            case 1: {
                exceptionItem.setId(this.readString());
                break;
            }
            case 2: {
                exceptionItem.setCount(this.readInt());
                break;
            }
            case 3: {
                if (_type == 1) {
                    exceptionItem.addMessage(this.readString());
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    exceptionItem.addMessage(this.readString());
                }
                break;
            }
        }
    }

    private Date readDate() {
        try {
            return new Date(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readInt() {
        try {
            return (int)this.readVarint(32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readString() {
        try {
            return this.m_in.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte readTag() {
        try {
            return this.m_in.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected long readVarint(int length) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < length; shift += 7) {
            byte b = this.m_in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("Malformed variable int " + length + "!");
    }
}

