/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.bug.transform;

import com.dianping.cat.home.bug.IEntity;
import com.dianping.cat.home.bug.entity.BugReport;
import com.dianping.cat.home.bug.entity.Domain;
import com.dianping.cat.home.bug.entity.ExceptionItem;
import com.dianping.cat.home.bug.transform.DefaultLinker;
import com.dianping.cat.home.bug.transform.DefaultSaxMaker;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static BugReport parse(InputSource is) throws SAXException, IOException {
        return (BugReport)DefaultSaxParser.parseEntity(BugReport.class, (InputSource)is);
    }

    public static BugReport parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(in));
    }

    public static BugReport parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(reader));
    }

    public static BugReport parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.m_objs.pop();
            String currentTag = (String)this.m_tags.pop();
            if (currentObj instanceof Domain) {
                Domain domain = (Domain)currentObj;
                if ("problem-url".equals(currentTag)) {
                    domain.setProblemUrl(this.getText());
                } else if ("excpetion".equals(currentTag)) {
                    domain.setExcpetion(this.getText());
                }
            } else if (currentObj instanceof ExceptionItem) {
                ExceptionItem exceptionItem = (ExceptionItem)currentObj;
                if ("message".equals(currentTag)) {
                    exceptionItem.addMessage(this.getText());
                }
            }
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForBugReport(BugReport parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"domain".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under bug-report!", qName));
        }
        Domain domain = this.m_maker.buildDomain(attributes);
        this.m_linker.onDomain(parentObj, domain);
        this.m_objs.push(domain);
        this.m_tags.push(qName);
    }

    private void parseForDomain(Domain parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("problem-url".equals(qName) || "excpetion".equals(qName)) {
            this.m_objs.push(parentObj);
        } else if ("exception-item".equals(qName)) {
            ExceptionItem exceptionItem = this.m_maker.buildExceptionItem(attributes);
            this.m_linker.onExceptionItem(parentObj, exceptionItem);
            this.m_objs.push(exceptionItem);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under domain!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForExceptionItem(ExceptionItem parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"messages".equals(qName) && !"message".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under exception-item!", qName));
        }
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("bug-report".equals(qName)) {
            BugReport bugReport = this.m_maker.buildBugReport(attributes);
            this.m_entity = bugReport;
            this.m_objs.push(bugReport);
            this.m_tags.push(qName);
        } else if ("domain".equals(qName)) {
            Domain domain = this.m_maker.buildDomain(attributes);
            this.m_entity = domain;
            this.m_objs.push(domain);
            this.m_tags.push(qName);
        } else if ("exception-item".equals(qName)) {
            ExceptionItem exceptionItem = this.m_maker.buildExceptionItem(attributes);
            this.m_entity = exceptionItem;
            this.m_objs.push(exceptionItem);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof BugReport) {
                this.parseForBugReport((BugReport)parent, tag, qName, attributes);
            } else if (parent instanceof Domain) {
                this.parseForDomain((Domain)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof ExceptionItem)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForExceptionItem((ExceptionItem)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }

    protected Date toDate(String str, String format) {
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

