/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.config.entity;

import com.dianping.cat.home.dependency.config.BaseEntity;
import com.dianping.cat.home.dependency.config.IVisitor;
import com.dianping.cat.home.dependency.config.entity.DomainConfig;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeConfig
extends BaseEntity<NodeConfig> {
    private String m_type;
    private Integer m_defaultWarningThreshold;
    private Integer m_defaultErrorThreshold;
    private Double m_defaultWarningResponseTime;
    private Double m_defaultErrorResponseTime;
    private Map<String, DomainConfig> m_domainConfigs = new LinkedHashMap();
    private int m_defaultMinCountThreshold = 100;

    public NodeConfig() {
    }

    public NodeConfig(String type) {
        this.m_type = type;
    }

    public void accept(IVisitor visitor) {
        visitor.visitNodeConfig(this);
    }

    public NodeConfig addDomainConfig(DomainConfig domainConfig) {
        this.m_domainConfigs.put(domainConfig.getId(), domainConfig);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeConfig) {
            NodeConfig _o = (NodeConfig)obj;
            return this.equals((Object)this.m_type, (Object)_o.getType());
        }
        return false;
    }

    public DomainConfig findDomainConfig(String id) {
        return (DomainConfig)this.m_domainConfigs.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainConfig findOrCreateDomainConfig(String id) {
        DomainConfig domainConfig = (DomainConfig)this.m_domainConfigs.get(id);
        if (domainConfig == null) {
            Map map = this.m_domainConfigs;
            synchronized (map) {
                domainConfig = (DomainConfig)this.m_domainConfigs.get(id);
                if (domainConfig == null) {
                    domainConfig = new DomainConfig(id);
                    this.m_domainConfigs.put(id, domainConfig);
                }
            }
        }
        return domainConfig;
    }

    public Double getDefaultErrorResponseTime() {
        return this.m_defaultErrorResponseTime;
    }

    public Integer getDefaultErrorThreshold() {
        return this.m_defaultErrorThreshold;
    }

    public int getDefaultMinCountThreshold() {
        return this.m_defaultMinCountThreshold;
    }

    public Double getDefaultWarningResponseTime() {
        return this.m_defaultWarningResponseTime;
    }

    public Integer getDefaultWarningThreshold() {
        return this.m_defaultWarningThreshold;
    }

    public Map<String, DomainConfig> getDomainConfigs() {
        return this.m_domainConfigs;
    }

    public String getType() {
        return this.m_type;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_type == null ? 0 : this.m_type.hashCode());
        return hash;
    }

    public void mergeAttributes(NodeConfig other) {
        this.assertAttributeEquals((Object)other, "node-config", "type", (Object)this.m_type, (Object)other.getType());
        if (other.getDefaultWarningThreshold() != null) {
            this.m_defaultWarningThreshold = other.getDefaultWarningThreshold();
        }
        if (other.getDefaultErrorThreshold() != null) {
            this.m_defaultErrorThreshold = other.getDefaultErrorThreshold();
        }
        if (other.getDefaultWarningResponseTime() != null) {
            this.m_defaultWarningResponseTime = other.getDefaultWarningResponseTime();
        }
        if (other.getDefaultErrorResponseTime() != null) {
            this.m_defaultErrorResponseTime = other.getDefaultErrorResponseTime();
        }
        this.m_defaultMinCountThreshold = other.getDefaultMinCountThreshold();
    }

    public DomainConfig removeDomainConfig(String id) {
        return (DomainConfig)this.m_domainConfigs.remove(id);
    }

    public NodeConfig setDefaultErrorResponseTime(Double defaultErrorResponseTime) {
        this.m_defaultErrorResponseTime = defaultErrorResponseTime;
        return this;
    }

    public NodeConfig setDefaultErrorThreshold(Integer defaultErrorThreshold) {
        this.m_defaultErrorThreshold = defaultErrorThreshold;
        return this;
    }

    public NodeConfig setDefaultMinCountThreshold(int defaultMinCountThreshold) {
        this.m_defaultMinCountThreshold = defaultMinCountThreshold;
        return this;
    }

    public NodeConfig setDefaultWarningResponseTime(Double defaultWarningResponseTime) {
        this.m_defaultWarningResponseTime = defaultWarningResponseTime;
        return this;
    }

    public NodeConfig setDefaultWarningThreshold(Integer defaultWarningThreshold) {
        this.m_defaultWarningThreshold = defaultWarningThreshold;
        return this;
    }

    public NodeConfig setType(String type) {
        this.m_type = type;
        return this;
    }
}

