/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.config.entity;

import com.dianping.cat.home.dependency.config.BaseEntity;
import com.dianping.cat.home.dependency.config.IVisitor;
import com.dianping.cat.home.dependency.config.entity.EdgeConfig;
import com.dianping.cat.home.dependency.config.entity.NodeConfig;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologyGraphConfig
extends BaseEntity<TopologyGraphConfig> {
    private Map<String, NodeConfig> m_nodeConfigs = new LinkedHashMap();
    private Map<String, EdgeConfig> m_edgeConfigs = new LinkedHashMap();

    public void accept(IVisitor visitor) {
        visitor.visitTopologyGraphConfig(this);
    }

    public TopologyGraphConfig addEdgeConfig(EdgeConfig edgeConfig) {
        this.m_edgeConfigs.put(edgeConfig.getKey(), edgeConfig);
        return this;
    }

    public TopologyGraphConfig addNodeConfig(NodeConfig nodeConfig) {
        this.m_nodeConfigs.put(nodeConfig.getType(), nodeConfig);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TopologyGraphConfig) {
            TopologyGraphConfig _o = (TopologyGraphConfig)obj;
            if (!this.equals((Object)this.m_nodeConfigs, (Object)_o.getNodeConfigs())) {
                return false;
            }
            return this.equals((Object)this.m_edgeConfigs, (Object)_o.getEdgeConfigs());
        }
        return false;
    }

    public EdgeConfig findEdgeConfig(String key) {
        return (EdgeConfig)this.m_edgeConfigs.get(key);
    }

    public NodeConfig findNodeConfig(String type) {
        return (NodeConfig)this.m_nodeConfigs.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EdgeConfig findOrCreateEdgeConfig(String key) {
        EdgeConfig edgeConfig = (EdgeConfig)this.m_edgeConfigs.get(key);
        if (edgeConfig == null) {
            Map map = this.m_edgeConfigs;
            synchronized (map) {
                edgeConfig = (EdgeConfig)this.m_edgeConfigs.get(key);
                if (edgeConfig == null) {
                    edgeConfig = new EdgeConfig(key);
                    this.m_edgeConfigs.put(key, edgeConfig);
                }
            }
        }
        return edgeConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeConfig findOrCreateNodeConfig(String type) {
        NodeConfig nodeConfig = (NodeConfig)this.m_nodeConfigs.get(type);
        if (nodeConfig == null) {
            Map map = this.m_nodeConfigs;
            synchronized (map) {
                nodeConfig = (NodeConfig)this.m_nodeConfigs.get(type);
                if (nodeConfig == null) {
                    nodeConfig = new NodeConfig(type);
                    this.m_nodeConfigs.put(type, nodeConfig);
                }
            }
        }
        return nodeConfig;
    }

    public Map<String, EdgeConfig> getEdgeConfigs() {
        return this.m_edgeConfigs;
    }

    public Map<String, NodeConfig> getNodeConfigs() {
        return this.m_nodeConfigs;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_nodeConfigs == null ? 0 : this.m_nodeConfigs.hashCode());
        hash = hash * 31 + (this.m_edgeConfigs == null ? 0 : this.m_edgeConfigs.hashCode());
        return hash;
    }

    public void mergeAttributes(TopologyGraphConfig other) {
    }

    public EdgeConfig removeEdgeConfig(String key) {
        return (EdgeConfig)this.m_edgeConfigs.remove(key);
    }

    public NodeConfig removeNodeConfig(String type) {
        return (NodeConfig)this.m_nodeConfigs.remove(type);
    }
}

