/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.config.transform;

import com.dianping.cat.home.dependency.config.IEntity;
import com.dianping.cat.home.dependency.config.entity.DomainConfig;
import com.dianping.cat.home.dependency.config.entity.EdgeConfig;
import com.dianping.cat.home.dependency.config.entity.NodeConfig;
import com.dianping.cat.home.dependency.config.entity.TopologyGraphConfig;
import com.dianping.cat.home.dependency.config.transform.DefaultLinker;
import com.dianping.cat.home.dependency.config.transform.DefaultSaxMaker;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static TopologyGraphConfig parse(InputSource is) throws SAXException, IOException {
        return (TopologyGraphConfig)DefaultSaxParser.parseEntity(TopologyGraphConfig.class, (InputSource)is);
    }

    public static TopologyGraphConfig parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(in));
    }

    public static TopologyGraphConfig parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(reader));
    }

    public static TopologyGraphConfig parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            this.m_objs.pop();
            this.m_tags.pop();
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForDomainConfig(DomainConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForEdgeConfig(EdgeConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForNodeConfig(NodeConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"domain-config".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under node-config!", qName));
        }
        DomainConfig domainConfig = this.m_maker.buildDomainConfig(attributes);
        this.m_linker.onDomainConfig(parentObj, domainConfig);
        this.m_objs.push(domainConfig);
        this.m_tags.push(qName);
    }

    private void parseForTopologyGraphConfig(TopologyGraphConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("node-config".equals(qName)) {
            NodeConfig nodeConfig = this.m_maker.buildNodeConfig(attributes);
            this.m_linker.onNodeConfig(parentObj, nodeConfig);
            this.m_objs.push(nodeConfig);
        } else if ("edge-config".equals(qName)) {
            EdgeConfig edgeConfig = this.m_maker.buildEdgeConfig(attributes);
            this.m_linker.onEdgeConfig(parentObj, edgeConfig);
            this.m_objs.push(edgeConfig);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under topology-graph-config!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("topology-graph-config".equals(qName)) {
            TopologyGraphConfig topologyGraphConfig = this.m_maker.buildTopologyGraphConfig(attributes);
            this.m_entity = topologyGraphConfig;
            this.m_objs.push(topologyGraphConfig);
            this.m_tags.push(qName);
        } else if ("node-config".equals(qName)) {
            NodeConfig nodeConfig = this.m_maker.buildNodeConfig(attributes);
            this.m_entity = nodeConfig;
            this.m_objs.push(nodeConfig);
            this.m_tags.push(qName);
        } else if ("domain-config".equals(qName)) {
            DomainConfig domainConfig = this.m_maker.buildDomainConfig(attributes);
            this.m_entity = domainConfig;
            this.m_objs.push(domainConfig);
            this.m_tags.push(qName);
        } else if ("edge-config".equals(qName)) {
            EdgeConfig edgeConfig = this.m_maker.buildEdgeConfig(attributes);
            this.m_entity = edgeConfig;
            this.m_objs.push(edgeConfig);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof TopologyGraphConfig) {
                this.parseForTopologyGraphConfig((TopologyGraphConfig)parent, tag, qName, attributes);
            } else if (parent instanceof NodeConfig) {
                this.parseForNodeConfig((NodeConfig)parent, tag, qName, attributes);
            } else if (parent instanceof DomainConfig) {
                this.parseForDomainConfig((DomainConfig)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof EdgeConfig)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForEdgeConfig((EdgeConfig)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

