/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.format.transform;

import com.dianping.cat.home.dependency.format.IEntity;
import com.dianping.cat.home.dependency.format.entity.ProductLine;
import com.dianping.cat.home.dependency.format.entity.TopoGraphFormatConfig;
import com.dianping.cat.home.dependency.format.transform.DefaultLinker;
import com.dianping.cat.home.dependency.format.transform.DefaultSaxMaker;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static TopoGraphFormatConfig parse(InputSource is) throws SAXException, IOException {
        return (TopoGraphFormatConfig)DefaultSaxParser.parseEntity(TopoGraphFormatConfig.class, (InputSource)is);
    }

    public static TopoGraphFormatConfig parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(in));
    }

    public static TopoGraphFormatConfig parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(reader));
    }

    public static TopoGraphFormatConfig parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            this.m_objs.pop();
            this.m_tags.pop();
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForProductLine(ProductLine parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForTopoGraphFormatConfig(TopoGraphFormatConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"productLine".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under topoGraph-format-config!", qName));
        }
        ProductLine productLine = this.m_maker.buildProductLine(attributes);
        this.m_linker.onProductLine(parentObj, productLine);
        this.m_objs.push(productLine);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("topoGraph-format-config".equals(qName)) {
            TopoGraphFormatConfig topoGraphFormatConfig = this.m_maker.buildTopoGraphFormatConfig(attributes);
            this.m_entity = topoGraphFormatConfig;
            this.m_objs.push(topoGraphFormatConfig);
            this.m_tags.push(qName);
        } else if ("productLine".equals(qName)) {
            ProductLine productLine = this.m_maker.buildProductLine(attributes);
            this.m_entity = productLine;
            this.m_objs.push(productLine);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof TopoGraphFormatConfig) {
                this.parseForTopoGraphFormatConfig((TopoGraphFormatConfig)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof ProductLine)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForProductLine((ProductLine)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

