/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.graph.entity;

import com.dianping.cat.home.dependency.graph.BaseEntity;
import com.dianping.cat.home.dependency.graph.IVisitor;
import com.dianping.cat.home.dependency.graph.entity.TopologyEdge;
import com.dianping.cat.home.dependency.graph.entity.TopologyNode;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologyGraph
extends BaseEntity<TopologyGraph> {
    private String m_id;
    private String m_type;
    private int m_status;
    private String m_des;
    private Map<String, TopologyNode> m_nodes = new LinkedHashMap();
    private Map<String, TopologyEdge> m_edges = new LinkedHashMap();

    public void accept(IVisitor visitor) {
        visitor.visitTopologyGraph(this);
    }

    public TopologyGraph addTopologyEdge(TopologyEdge topologyEdge) {
        this.m_edges.put(topologyEdge.getKey(), topologyEdge);
        return this;
    }

    public TopologyGraph addTopologyNode(TopologyNode topologyNode) {
        this.m_nodes.put(topologyNode.getId(), topologyNode);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TopologyGraph) {
            TopologyGraph _o = (TopologyGraph)obj;
            if (!this.equals((Object)this.m_id, (Object)_o.getId())) {
                return false;
            }
            if (!this.equals((Object)this.m_type, (Object)_o.getType())) {
                return false;
            }
            if (this.m_status != _o.getStatus()) {
                return false;
            }
            if (!this.equals((Object)this.m_des, (Object)_o.getDes())) {
                return false;
            }
            if (!this.equals((Object)this.m_nodes, (Object)_o.getNodes())) {
                return false;
            }
            return this.equals((Object)this.m_edges, (Object)_o.getEdges());
        }
        return false;
    }

    public TopologyEdge findTopologyEdge(String key) {
        return (TopologyEdge)this.m_edges.get(key);
    }

    public TopologyNode findTopologyNode(String id) {
        return (TopologyNode)this.m_nodes.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyEdge findOrCreateTopologyEdge(String key) {
        TopologyEdge topologyEdge = (TopologyEdge)this.m_edges.get(key);
        if (topologyEdge == null) {
            Map map = this.m_edges;
            synchronized (map) {
                topologyEdge = (TopologyEdge)this.m_edges.get(key);
                if (topologyEdge == null) {
                    topologyEdge = new TopologyEdge(key);
                    this.m_edges.put(key, topologyEdge);
                }
            }
        }
        return topologyEdge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyNode findOrCreateTopologyNode(String id) {
        TopologyNode topologyNode = (TopologyNode)this.m_nodes.get(id);
        if (topologyNode == null) {
            Map map = this.m_nodes;
            synchronized (map) {
                topologyNode = (TopologyNode)this.m_nodes.get(id);
                if (topologyNode == null) {
                    topologyNode = new TopologyNode(id);
                    this.m_nodes.put(id, topologyNode);
                }
            }
        }
        return topologyNode;
    }

    public String getDes() {
        return this.m_des;
    }

    public Map<String, TopologyEdge> getEdges() {
        return this.m_edges;
    }

    public String getId() {
        return this.m_id;
    }

    public Map<String, TopologyNode> getNodes() {
        return this.m_nodes;
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getType() {
        return this.m_type;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        hash = hash * 31 + (this.m_type == null ? 0 : this.m_type.hashCode());
        hash = hash * 31 + this.m_status;
        hash = hash * 31 + (this.m_des == null ? 0 : this.m_des.hashCode());
        hash = hash * 31 + (this.m_nodes == null ? 0 : this.m_nodes.hashCode());
        hash = hash * 31 + (this.m_edges == null ? 0 : this.m_edges.hashCode());
        return hash;
    }

    public void mergeAttributes(TopologyGraph other) {
        if (other.getId() != null) {
            this.m_id = other.getId();
        }
        if (other.getType() != null) {
            this.m_type = other.getType();
        }
        this.m_status = other.getStatus();
        if (other.getDes() != null) {
            this.m_des = other.getDes();
        }
    }

    public TopologyEdge removeTopologyEdge(String key) {
        return (TopologyEdge)this.m_edges.remove(key);
    }

    public TopologyNode removeTopologyNode(String id) {
        return (TopologyNode)this.m_nodes.remove(id);
    }

    public TopologyGraph setDes(String des) {
        this.m_des = des;
        return this;
    }

    public TopologyGraph setId(String id) {
        this.m_id = id;
        return this;
    }

    public TopologyGraph setStatus(int status) {
        this.m_status = status;
        return this;
    }

    public TopologyGraph setType(String type) {
        this.m_type = type;
        return this;
    }
}

