/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.graph.transform;

import com.dianping.cat.home.dependency.graph.IEntity;
import com.dianping.cat.home.dependency.graph.IVisitor;
import com.dianping.cat.home.dependency.graph.entity.TopologyEdge;
import com.dianping.cat.home.dependency.graph.entity.TopologyGraph;
import com.dianping.cat.home.dependency.graph.entity.TopologyNode;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private TopologyGraph m_topologyGraph;

    public DefaultMerger() {
    }

    public DefaultMerger(TopologyGraph topologyGraph) {
        this.m_topologyGraph = topologyGraph;
        this.m_objs.push(topologyGraph);
    }

    public TopologyGraph getTopologyGraph() {
        return this.m_topologyGraph;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeTopologyEdge(TopologyEdge to, TopologyEdge from) {
        to.mergeAttributes(from);
    }

    protected void mergeTopologyGraph(TopologyGraph to, TopologyGraph from) {
        to.mergeAttributes(from);
    }

    protected void mergeTopologyNode(TopologyNode to, TopologyNode from) {
        to.mergeAttributes(from);
    }

    public void visitTopologyEdge(TopologyEdge from) {
        TopologyEdge to = (TopologyEdge)this.m_objs.peek();
        this.mergeTopologyEdge(to, from);
        this.visitTopologyEdgeChildren(to, from);
    }

    protected void visitTopologyEdgeChildren(TopologyEdge to, TopologyEdge from) {
    }

    public void visitTopologyGraph(TopologyGraph from) {
        TopologyGraph to = (TopologyGraph)this.m_objs.peek();
        this.mergeTopologyGraph(to, from);
        this.visitTopologyGraphChildren(to, from);
    }

    protected void visitTopologyGraphChildren(TopologyGraph to, TopologyGraph from) {
        TopologyNode target;
        for (TopologyNode source : from.getNodes().values()) {
            target = to.findTopologyNode(source.getId());
            if (target == null) {
                target = new TopologyNode(source.getId());
                to.addTopologyNode(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (TopologyNode source : from.getEdges().values()) {
            target = to.findTopologyEdge(source.getKey());
            if (target == null) {
                target = new TopologyEdge(source.getKey());
                to.addTopologyEdge((TopologyEdge)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitTopologyNode(TopologyNode from) {
        TopologyNode to = (TopologyNode)this.m_objs.peek();
        this.mergeTopologyNode(to, from);
        this.visitTopologyNodeChildren(to, from);
    }

    protected void visitTopologyNodeChildren(TopologyNode to, TopologyNode from) {
    }
}

