/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.group.transform;

import com.dianping.cat.home.group.IEntity;
import com.dianping.cat.home.group.IVisitor;
import com.dianping.cat.home.group.entity.Domain;
import com.dianping.cat.home.group.entity.DomainGroup;
import com.dianping.cat.home.group.entity.Group;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJsonBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultJsonBuilder() {
        this(false);
    }

    public DefaultJsonBuilder(boolean compact) {
        this(compact, new StringBuilder(4096));
    }

    public DefaultJsonBuilder(boolean compact, StringBuilder sb) {
        this.m_compact = compact;
        this.m_sb = sb;
        this.m_visitor = this;
    }

    protected void arrayBegin(String name) {
        this.indent();
        this.m_sb.append('\"').append(name).append(this.m_compact ? "\":[" : "\": [\r\n");
        ++this.m_level;
    }

    protected void arrayEnd(String name) {
        --this.m_level;
        this.trimComma();
        this.indent();
        this.m_sb.append("],").append(this.m_compact ? "" : "\r\n");
    }

    protected void attributes(Map<String, String> dynamicAttributes, Object ... nameValues) {
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                if (attrValue instanceof List) {
                    List list = (List)attrValue;
                    if (!list.isEmpty()) {
                        this.indent();
                        this.m_sb.append('\"').append(attrName).append(this.m_compact ? "\":[" : "\": [");
                        for (Object item : list) {
                            this.m_sb.append(' ');
                            this.toString(this.m_sb, item);
                            this.m_sb.append(',');
                        }
                        this.m_sb.setLength(this.m_sb.length() - 1);
                        this.m_sb.append(this.m_compact ? "]," : " ],\r\n");
                    }
                } else if (this.m_compact) {
                    this.m_sb.append('\"').append(attrName).append("\":");
                    this.toString(this.m_sb, attrValue);
                    this.m_sb.append(",");
                } else {
                    this.indent();
                    this.m_sb.append('\"').append(attrName).append("\": ");
                    this.toString(this.m_sb, attrValue);
                    this.m_sb.append(",\r\n");
                }
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                if (this.m_compact) {
                    this.m_sb.append('\"').append(e.getKey()).append("\":");
                    this.toString(this.m_sb, (Object)e.getValue());
                    this.m_sb.append(",");
                    continue;
                }
                this.indent();
                this.m_sb.append('\"').append(e.getKey()).append("\": ");
                this.toString(this.m_sb, (Object)e.getValue());
                this.m_sb.append(",\r\n");
            }
        }
    }

    public String build(IEntity<?> entity) {
        this.objectBegin(null);
        entity.accept((IVisitor)this);
        this.objectEnd(null);
        this.trimComma();
        return this.m_sb.toString();
    }

    public String buildArray(Collection<? extends IEntity<?>> entities) {
        this.m_sb.append('[');
        if (entities != null) {
            for (IEntity<?> entity : entities) {
                this.objectBegin(null);
                entity.accept((IVisitor)this);
                this.objectEnd(null);
            }
            this.trimComma();
        }
        this.m_sb.append(']');
        return this.m_sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void objectBegin(String name) {
        this.indent();
        if (name == null) {
            this.m_sb.append("{").append(this.m_compact ? "" : "\r\n");
        } else {
            this.m_sb.append('\"').append(name).append(this.m_compact ? "\":{" : "\": {\r\n");
        }
        ++this.m_level;
    }

    protected void objectEnd(String name) {
        --this.m_level;
        this.trimComma();
        this.indent();
        this.m_sb.append(this.m_compact ? "}," : "},\r\n");
    }

    protected void toString(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof Boolean || value instanceof Number) {
            sb.append(value);
        } else {
            String val = value.toString();
            int len = val.length();
            sb.append('\"');
            block6: for (int i = 0; i < len; ++i) {
                char ch = val.charAt(i);
                switch (ch) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        sb.append('\\').append(ch);
                        continue block6;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block6;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block6;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block6;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            sb.append('\"');
        }
    }

    protected void trimComma() {
        int len = this.m_sb.length();
        if (this.m_compact) {
            if (len > 1 && this.m_sb.charAt(len - 1) == ',') {
                this.m_sb.replace(len - 1, len, "");
            }
        } else if (len > 3 && this.m_sb.charAt(len - 3) == ',') {
            this.m_sb.replace(len - 3, len - 2, "");
        }
    }

    public void visitDomain(Domain domain) {
        this.attributes(null, new Object[]{"id", domain.getId()});
        if (!domain.getGroups().isEmpty()) {
            this.objectBegin("groups");
            for (Map.Entry e : domain.getGroups().entrySet()) {
                String key = String.valueOf(e.getKey());
                this.objectBegin(key);
                ((Group)e.getValue()).accept(this.m_visitor);
                this.objectEnd(key);
            }
            this.objectEnd("groups");
        }
    }

    public void visitDomainGroup(DomainGroup domainGroup) {
        if (!domainGroup.getDomains().isEmpty()) {
            this.objectBegin("domains");
            for (Map.Entry e : domainGroup.getDomains().entrySet()) {
                String key = String.valueOf(e.getKey());
                this.objectBegin(key);
                ((Domain)e.getValue()).accept(this.m_visitor);
                this.objectEnd(key);
            }
            this.objectEnd("domains");
        }
    }

    public void visitGroup(Group group) {
        this.attributes(null, new Object[]{"id", group.getId()});
        if (!group.getIps().isEmpty()) {
            this.arrayBegin("ips");
            for (String ip : group.getIps()) {
                this.indent();
                this.m_sb.append('\"').append(ip).append(this.m_compact ? "\"," : "\",\r\n");
            }
            this.arrayEnd("ips");
        }
    }
}

