/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.group.transform;

import com.dianping.cat.home.group.IEntity;
import com.dianping.cat.home.group.IVisitor;
import com.dianping.cat.home.group.entity.Domain;
import com.dianping.cat.home.group.entity.DomainGroup;
import com.dianping.cat.home.group.entity.Group;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private DomainGroup m_domainGroup;

    public DefaultMerger() {
    }

    public DefaultMerger(DomainGroup domainGroup) {
        this.m_domainGroup = domainGroup;
        this.m_objs.push(domainGroup);
    }

    public DomainGroup getDomainGroup() {
        return this.m_domainGroup;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeDomain(Domain to, Domain from) {
        to.mergeAttributes(from);
    }

    protected void mergeDomainGroup(DomainGroup to, DomainGroup from) {
        to.mergeAttributes(from);
    }

    protected void mergeGroup(Group to, Group from) {
        to.mergeAttributes(from);
        to.getIps().addAll(from.getIps());
    }

    public void visitDomain(Domain from) {
        Domain to = (Domain)this.m_objs.peek();
        this.mergeDomain(to, from);
        this.visitDomainChildren(to, from);
    }

    protected void visitDomainChildren(Domain to, Domain from) {
        for (Group source : from.getGroups().values()) {
            Group target = to.findGroup(source.getId());
            if (target == null) {
                target = new Group(source.getId());
                to.addGroup(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitDomainGroup(DomainGroup from) {
        DomainGroup to = (DomainGroup)this.m_objs.peek();
        this.mergeDomainGroup(to, from);
        this.visitDomainGroupChildren(to, from);
    }

    protected void visitDomainGroupChildren(DomainGroup to, DomainGroup from) {
        for (Domain source : from.getDomains().values()) {
            Domain target = to.findDomain(source.getId());
            if (target == null) {
                target = new Domain(source.getId());
                to.addDomain(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitGroup(Group from) {
        Group to = (Group)this.m_objs.peek();
        this.mergeGroup(to, from);
        this.visitGroupChildren(to, from);
    }

    protected void visitGroupChildren(Group to, Group from) {
    }
}

