/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.group.transform;

import com.dianping.cat.home.group.IVisitor;
import com.dianping.cat.home.group.entity.Domain;
import com.dianping.cat.home.group.entity.DomainGroup;
import com.dianping.cat.home.group.entity.Group;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private DataOutputStream m_out;

    public DefaultNativeBuilder(OutputStream out) {
        this(out, null);
    }

    public DefaultNativeBuilder(OutputStream out, IVisitor visitor) {
        this.m_out = new DataOutputStream(out);
        this.m_visitor = visitor == null ? this : visitor;
    }

    public static byte[] build(DomainGroup domainGroup) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DefaultNativeBuilder.build((DomainGroup)domainGroup, (OutputStream)out);
        return out.toByteArray();
    }

    public static void build(DomainGroup domainGroup, OutputStream out) {
        domainGroup.accept((IVisitor)new DefaultNativeBuilder(out));
    }

    public void visitDomain(Domain domain) {
        if (domain.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(domain.getId());
        }
        if (!domain.getGroups().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(domain.getGroups().size());
            for (Group group : domain.getGroups().values()) {
                group.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitDomainGroup(DomainGroup domainGroup) {
        this.writeTag(63, 0);
        if (!domainGroup.getDomains().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(domainGroup.getDomains().size());
            for (Domain domain : domainGroup.getDomains().values()) {
                domain.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitGroup(Group group) {
        if (group.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(group.getId());
        }
        if (!group.getIps().isEmpty()) {
            this.writeTag(2, 2);
            this.writeInt(group.getIps().size());
            for (String ip : group.getIps()) {
                this.writeString(ip);
            }
        }
        this.writeTag(63, 3);
    }

    private void writeInt(int value) {
        try {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String value) {
        try {
            this.m_out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(int field, int type) {
        try {
            this.m_out.writeByte((field << 2) + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVarint(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.m_out.writeByte((byte)value);
                return;
            }
            this.m_out.writeByte((byte)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }
}

