/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.heartbeat.entity;

import com.dianping.cat.home.heartbeat.BaseEntity;
import com.dianping.cat.home.heartbeat.IVisitor;
import com.dianping.cat.home.heartbeat.entity.Metric;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends BaseEntity<Group> {
    private String m_id;
    private int m_order;
    private Map<String, Metric> m_metrics = new LinkedHashMap();

    public Group() {
    }

    public Group(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitGroup(this);
    }

    public Group addMetric(Metric metric) {
        this.m_metrics.put(metric.getId(), metric);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Group) {
            Group _o = (Group)obj;
            return this.equals((Object)this.m_id, (Object)_o.getId());
        }
        return false;
    }

    public Metric findMetric(String id) {
        return (Metric)this.m_metrics.get(id);
    }

    public String getId() {
        return this.m_id;
    }

    public Map<String, Metric> getMetrics() {
        return this.m_metrics;
    }

    public int getOrder() {
        return this.m_order;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Group other) {
        this.assertAttributeEquals((Object)other, "group", "id", (Object)this.m_id, (Object)other.getId());
        this.m_order = other.getOrder();
    }

    public Metric removeMetric(String id) {
        return (Metric)this.m_metrics.remove(id);
    }

    public Group setId(String id) {
        this.m_id = id;
        return this;
    }

    public Group setOrder(int order) {
        this.m_order = order;
        return this;
    }
}

