/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.heavy.entity;

import com.dianping.cat.home.heavy.BaseEntity;
import com.dianping.cat.home.heavy.IVisitor;
import com.dianping.cat.home.heavy.entity.Service;
import com.dianping.cat.home.heavy.entity.Url;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeavyCall
extends BaseEntity<HeavyCall> {
    private Map<String, Url> m_urls = new LinkedHashMap();
    private Map<String, Service> m_services = new LinkedHashMap();

    public void accept(IVisitor visitor) {
        visitor.visitHeavyCall(this);
    }

    public HeavyCall addService(Service service) {
        this.m_services.put(service.getKey(), service);
        return this;
    }

    public HeavyCall addUrl(Url url) {
        this.m_urls.put(url.getKey(), url);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HeavyCall) {
            HeavyCall _o = (HeavyCall)obj;
            if (!this.equals((Object)this.m_urls, (Object)_o.getUrls())) {
                return false;
            }
            return this.equals((Object)this.m_services, (Object)_o.getServices());
        }
        return false;
    }

    public Service findService(String key) {
        return (Service)this.m_services.get(key);
    }

    public Url findUrl(String key) {
        return (Url)this.m_urls.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service findOrCreateService(String key) {
        Service service = (Service)this.m_services.get(key);
        if (service == null) {
            Map map = this.m_services;
            synchronized (map) {
                service = (Service)this.m_services.get(key);
                if (service == null) {
                    service = new Service(key);
                    this.m_services.put(key, service);
                }
            }
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Url findOrCreateUrl(String key) {
        Url url = (Url)this.m_urls.get(key);
        if (url == null) {
            Map map = this.m_urls;
            synchronized (map) {
                url = (Url)this.m_urls.get(key);
                if (url == null) {
                    url = new Url(key);
                    this.m_urls.put(key, url);
                }
            }
        }
        return url;
    }

    public Map<String, Service> getServices() {
        return this.m_services;
    }

    public Map<String, Url> getUrls() {
        return this.m_urls;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_urls == null ? 0 : this.m_urls.hashCode());
        hash = hash * 31 + (this.m_services == null ? 0 : this.m_services.hashCode());
        return hash;
    }

    public void mergeAttributes(HeavyCall other) {
    }

    public Service removeService(String key) {
        return (Service)this.m_services.remove(key);
    }

    public Url removeUrl(String key) {
        return (Url)this.m_urls.remove(key);
    }
}

