/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.heavy.transform;

import com.dianping.cat.home.heavy.IVisitor;
import com.dianping.cat.home.heavy.entity.HeavyCache;
import com.dianping.cat.home.heavy.entity.HeavyCall;
import com.dianping.cat.home.heavy.entity.HeavyReport;
import com.dianping.cat.home.heavy.entity.HeavySql;
import com.dianping.cat.home.heavy.entity.Service;
import com.dianping.cat.home.heavy.entity.Url;
import com.dianping.cat.home.heavy.transform.DefaultLinker;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeParser
implements IVisitor {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DataInputStream m_in;

    public DefaultNativeParser(InputStream in) {
        this.m_in = new DataInputStream(in);
    }

    public static HeavyReport parse(byte[] data) {
        return DefaultNativeParser.parse((InputStream)new ByteArrayInputStream(data));
    }

    public static HeavyReport parse(InputStream in) {
        HeavyReport heavyReport;
        DefaultNativeParser parser;
        block2: {
            parser = new DefaultNativeParser(in);
            heavyReport = new HeavyReport();
            try {
                heavyReport.accept((IVisitor)parser);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
        parser.m_linker.finish();
        return heavyReport;
    }

    public void visitHeavyCache(HeavyCache heavyCache) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitHeavyCacheChildren(heavyCache, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitHeavyCacheChildren(HeavyCache heavyCache, int _field, int _type) {
        switch (_field) {
            case 33: {
                if (_type == 1) {
                    Url urls = new Url();
                    this.visitUrl(urls);
                    this.m_linker.onUrl(heavyCache, urls);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Url urls = new Url();
                    this.visitUrl(urls);
                    this.m_linker.onUrl(heavyCache, urls);
                }
                break;
            }
            case 34: {
                if (_type == 1) {
                    Service services = new Service();
                    this.visitService(services);
                    this.m_linker.onService(heavyCache, services);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Service services = new Service();
                    this.visitService(services);
                    this.m_linker.onService(heavyCache, services);
                }
                break;
            }
        }
    }

    public void visitHeavyCall(HeavyCall heavyCall) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitHeavyCallChildren(heavyCall, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitHeavyCallChildren(HeavyCall heavyCall, int _field, int _type) {
        switch (_field) {
            case 33: {
                if (_type == 1) {
                    Url urls = new Url();
                    this.visitUrl(urls);
                    this.m_linker.onUrl(heavyCall, urls);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Url urls = new Url();
                    this.visitUrl(urls);
                    this.m_linker.onUrl(heavyCall, urls);
                }
                break;
            }
            case 34: {
                if (_type == 1) {
                    Service services = new Service();
                    this.visitService(services);
                    this.m_linker.onService(heavyCall, services);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Service services = new Service();
                    this.visitService(services);
                    this.m_linker.onService(heavyCall, services);
                }
                break;
            }
        }
    }

    public void visitHeavyReport(HeavyReport heavyReport) {
        byte tag = this.readTag();
        if (tag != -4) {
            throw new RuntimeException(String.format("Malformed payload, expected: %s, but was: %s!", -4, tag));
        }
        while ((tag = this.readTag()) != -1) {
            this.visitHeavyReportChildren(heavyReport, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitHeavyReportChildren(HeavyReport heavyReport, int _field, int _type) {
        switch (_field) {
            case 1: {
                heavyReport.setDomain(this.readString());
                break;
            }
            case 2: {
                heavyReport.setStartTime(this.readDate());
                break;
            }
            case 3: {
                heavyReport.setEndTime(this.readDate());
                break;
            }
            case 33: {
                HeavySql heavySql = new HeavySql();
                this.visitHeavySql(heavySql);
                this.m_linker.onHeavySql(heavyReport, heavySql);
                break;
            }
            case 34: {
                HeavyCall heavyCall = new HeavyCall();
                this.visitHeavyCall(heavyCall);
                this.m_linker.onHeavyCall(heavyReport, heavyCall);
                break;
            }
            case 35: {
                HeavyCache heavyCache = new HeavyCache();
                this.visitHeavyCache(heavyCache);
                this.m_linker.onHeavyCache(heavyReport, heavyCache);
            }
        }
    }

    public void visitHeavySql(HeavySql heavySql) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitHeavySqlChildren(heavySql, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitHeavySqlChildren(HeavySql heavySql, int _field, int _type) {
        switch (_field) {
            case 33: {
                if (_type == 1) {
                    Url urls = new Url();
                    this.visitUrl(urls);
                    this.m_linker.onUrl(heavySql, urls);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Url urls = new Url();
                    this.visitUrl(urls);
                    this.m_linker.onUrl(heavySql, urls);
                }
                break;
            }
            case 34: {
                if (_type == 1) {
                    Service services = new Service();
                    this.visitService(services);
                    this.m_linker.onService(heavySql, services);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Service services = new Service();
                    this.visitService(services);
                    this.m_linker.onService(heavySql, services);
                }
                break;
            }
        }
    }

    public void visitService(Service service) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitServiceChildren(service, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitServiceChildren(Service service, int _field, int _type) {
        switch (_field) {
            case 1: {
                service.setDomain(this.readString());
                break;
            }
            case 2: {
                service.setName(this.readString());
                break;
            }
            case 3: {
                service.setLogview(this.readString());
                break;
            }
            case 4: {
                service.setCount(this.readLong());
                break;
            }
            case 5: {
                service.setKey(this.readString());
            }
        }
    }

    public void visitUrl(Url url) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitUrlChildren(url, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitUrlChildren(Url url, int _field, int _type) {
        switch (_field) {
            case 1: {
                url.setDomain(this.readString());
                break;
            }
            case 2: {
                url.setName(this.readString());
                break;
            }
            case 3: {
                url.setLogview(this.readString());
                break;
            }
            case 4: {
                url.setCount(this.readLong());
                break;
            }
            case 5: {
                url.setKey(this.readString());
            }
        }
    }

    private Date readDate() {
        try {
            return new Date(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readInt() {
        try {
            return (int)this.readVarint(32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long readLong() {
        try {
            return this.readVarint(64);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readString() {
        try {
            return this.m_in.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte readTag() {
        try {
            return this.m_in.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected long readVarint(int length) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < length; shift += 7) {
            byte b = this.m_in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("Malformed variable int " + length + "!");
    }
}

