/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.jar.entity;

import com.dianping.cat.home.jar.BaseEntity;
import com.dianping.cat.home.jar.IVisitor;
import com.dianping.cat.home.jar.entity.Machine;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain
extends BaseEntity<Domain> {
    private String m_id;
    private Map<String, Machine> m_machines = new LinkedHashMap();

    public Domain() {
    }

    public Domain(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitDomain(this);
    }

    public Domain addMachine(Machine machine) {
        this.m_machines.put(machine.getId(), machine);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Domain) {
            Domain _o = (Domain)obj;
            return this.equals((Object)this.m_id, (Object)_o.getId());
        }
        return false;
    }

    public Machine findMachine(String id) {
        return (Machine)this.m_machines.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Machine findOrCreateMachine(String id) {
        Machine machine = (Machine)this.m_machines.get(id);
        if (machine == null) {
            Map map = this.m_machines;
            synchronized (map) {
                machine = (Machine)this.m_machines.get(id);
                if (machine == null) {
                    machine = new Machine(id);
                    this.m_machines.put(id, machine);
                }
            }
        }
        return machine;
    }

    public String getId() {
        return this.m_id;
    }

    public Map<String, Machine> getMachines() {
        return this.m_machines;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Domain other) {
        this.assertAttributeEquals((Object)other, "domain", "id", (Object)this.m_id, (Object)other.getId());
    }

    public Machine removeMachine(String id) {
        return (Machine)this.m_machines.remove(id);
    }

    public Domain setId(String id) {
        this.m_id = id;
        return this;
    }
}

