/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.jar.transform;

import com.dianping.cat.home.jar.IEntity;
import com.dianping.cat.home.jar.IVisitor;
import com.dianping.cat.home.jar.entity.Domain;
import com.dianping.cat.home.jar.entity.Jar;
import com.dianping.cat.home.jar.entity.JarReport;
import com.dianping.cat.home.jar.entity.Machine;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private JarReport m_jarReport;

    public DefaultMerger() {
    }

    public DefaultMerger(JarReport jarReport) {
        this.m_jarReport = jarReport;
        this.m_objs.push(jarReport);
    }

    public JarReport getJarReport() {
        return this.m_jarReport;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeDomain(Domain to, Domain from) {
        to.mergeAttributes(from);
    }

    protected void mergeJar(Jar to, Jar from) {
        to.mergeAttributes(from);
    }

    protected void mergeJarReport(JarReport to, JarReport from) {
        to.mergeAttributes(from);
    }

    protected void mergeMachine(Machine to, Machine from) {
        to.mergeAttributes(from);
    }

    public void visitDomain(Domain from) {
        Domain to = (Domain)this.m_objs.peek();
        this.mergeDomain(to, from);
        this.visitDomainChildren(to, from);
    }

    protected void visitDomainChildren(Domain to, Domain from) {
        for (Machine source : from.getMachines().values()) {
            Machine target = to.findMachine(source.getId());
            if (target == null) {
                target = new Machine(source.getId());
                to.addMachine(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitJar(Jar from) {
        Jar to = (Jar)this.m_objs.peek();
        this.mergeJar(to, from);
        this.visitJarChildren(to, from);
    }

    protected void visitJarChildren(Jar to, Jar from) {
    }

    public void visitJarReport(JarReport from) {
        JarReport to = (JarReport)this.m_objs.peek();
        this.mergeJarReport(to, from);
        this.visitJarReportChildren(to, from);
    }

    protected void visitJarReportChildren(JarReport to, JarReport from) {
        for (Domain source : from.getDomains().values()) {
            Domain target = to.findDomain(source.getId());
            if (target == null) {
                target = new Domain(source.getId());
                to.addDomain(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitMachine(Machine from) {
        Machine to = (Machine)this.m_objs.peek();
        this.mergeMachine(to, from);
        this.visitMachineChildren(to, from);
    }

    protected void visitMachineChildren(Machine to, Machine from) {
        for (Jar source : from.getJars()) {
            Jar target = null;
            if (target == null) {
                target = new Jar();
                to.addJar(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }
}

