/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.jar.transform;

import com.dianping.cat.home.jar.IVisitor;
import com.dianping.cat.home.jar.entity.Domain;
import com.dianping.cat.home.jar.entity.Jar;
import com.dianping.cat.home.jar.entity.JarReport;
import com.dianping.cat.home.jar.entity.Machine;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private DataOutputStream m_out;

    public DefaultNativeBuilder(OutputStream out) {
        this(out, null);
    }

    public DefaultNativeBuilder(OutputStream out, IVisitor visitor) {
        this.m_out = new DataOutputStream(out);
        this.m_visitor = visitor == null ? this : visitor;
    }

    public static byte[] build(JarReport jarReport) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DefaultNativeBuilder.build((JarReport)jarReport, (OutputStream)out);
        return out.toByteArray();
    }

    public static void build(JarReport jarReport, OutputStream out) {
        jarReport.accept((IVisitor)new DefaultNativeBuilder(out));
    }

    public void visitDomain(Domain domain) {
        if (domain.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(domain.getId());
        }
        if (!domain.getMachines().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(domain.getMachines().size());
            for (Machine machine : domain.getMachines().values()) {
                machine.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitJar(Jar jar) {
        if (jar.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(jar.getId());
        }
        if (jar.getVersion() != null) {
            this.writeTag(2, 1);
            this.writeString(jar.getVersion());
        }
        this.writeTag(63, 3);
    }

    public void visitJarReport(JarReport jarReport) {
        this.writeTag(63, 0);
        if (jarReport.getDomain() != null) {
            this.writeTag(1, 1);
            this.writeString(jarReport.getDomain());
        }
        if (jarReport.getStartTime() != null) {
            this.writeTag(2, 1);
            this.writeDate(jarReport.getStartTime());
        }
        if (jarReport.getEndTime() != null) {
            this.writeTag(3, 1);
            this.writeDate(jarReport.getEndTime());
        }
        if (!jarReport.getDomains().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(jarReport.getDomains().size());
            for (Domain domain : jarReport.getDomains().values()) {
                domain.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitMachine(Machine machine) {
        if (machine.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(machine.getId());
        }
        if (!machine.getJars().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(machine.getJars().size());
            for (Jar jar : machine.getJars()) {
                jar.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    private void writeDate(Date value) {
        try {
            this.writeVarint(value.getTime());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeInt(int value) {
        try {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String value) {
        try {
            this.m_out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(int field, int type) {
        try {
            this.m_out.writeByte((field << 2) + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVarint(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.m_out.writeByte((byte)value);
                return;
            }
            this.m_out.writeByte((byte)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }
}

