/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.jar.transform;

import com.dianping.cat.home.jar.IVisitor;
import com.dianping.cat.home.jar.entity.Domain;
import com.dianping.cat.home.jar.entity.Jar;
import com.dianping.cat.home.jar.entity.JarReport;
import com.dianping.cat.home.jar.entity.Machine;
import com.dianping.cat.home.jar.transform.DefaultLinker;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeParser
implements IVisitor {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DataInputStream m_in;

    public DefaultNativeParser(InputStream in) {
        this.m_in = new DataInputStream(in);
    }

    public static JarReport parse(byte[] data) {
        return DefaultNativeParser.parse((InputStream)new ByteArrayInputStream(data));
    }

    public static JarReport parse(InputStream in) {
        JarReport jarReport;
        DefaultNativeParser parser;
        block2: {
            parser = new DefaultNativeParser(in);
            jarReport = new JarReport();
            try {
                jarReport.accept((IVisitor)parser);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
        parser.m_linker.finish();
        return jarReport;
    }

    public void visitDomain(Domain domain) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitDomainChildren(domain, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitDomainChildren(Domain domain, int _field, int _type) {
        switch (_field) {
            case 1: {
                domain.setId(this.readString());
                break;
            }
            case 33: {
                if (_type == 1) {
                    Machine machines = new Machine();
                    this.visitMachine(machines);
                    this.m_linker.onMachine(domain, machines);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Machine machines = new Machine();
                    this.visitMachine(machines);
                    this.m_linker.onMachine(domain, machines);
                }
                break;
            }
        }
    }

    public void visitJar(Jar jar) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitJarChildren(jar, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitJarChildren(Jar jar, int _field, int _type) {
        switch (_field) {
            case 1: {
                jar.setId(this.readString());
                break;
            }
            case 2: {
                jar.setVersion(this.readString());
            }
        }
    }

    public void visitJarReport(JarReport jarReport) {
        byte tag = this.readTag();
        if (tag != -4) {
            throw new RuntimeException(String.format("Malformed payload, expected: %s, but was: %s!", -4, tag));
        }
        while ((tag = this.readTag()) != -1) {
            this.visitJarReportChildren(jarReport, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitJarReportChildren(JarReport jarReport, int _field, int _type) {
        switch (_field) {
            case 1: {
                jarReport.setDomain(this.readString());
                break;
            }
            case 2: {
                jarReport.setStartTime(this.readDate());
                break;
            }
            case 3: {
                jarReport.setEndTime(this.readDate());
                break;
            }
            case 33: {
                if (_type == 1) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(jarReport, domains);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(jarReport, domains);
                }
                break;
            }
        }
    }

    public void visitMachine(Machine machine) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitMachineChildren(machine, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitMachineChildren(Machine machine, int _field, int _type) {
        switch (_field) {
            case 1: {
                machine.setId(this.readString());
                break;
            }
            case 33: {
                if (_type == 1) {
                    Jar jars = new Jar();
                    this.visitJar(jars);
                    this.m_linker.onJar(machine, jars);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Jar jars = new Jar();
                    this.visitJar(jars);
                    this.m_linker.onJar(machine, jars);
                }
                break;
            }
        }
    }

    private Date readDate() {
        try {
            return new Date(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readInt() {
        try {
            return (int)this.readVarint(32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readString() {
        try {
            return this.m_in.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte readTag() {
        try {
            return this.m_in.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected long readVarint(int length) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < length; shift += 7) {
            byte b = this.m_in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("Malformed variable int " + length + "!");
    }
}

