/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.jar.transform;

import com.dianping.cat.home.jar.entity.Domain;
import com.dianping.cat.home.jar.entity.Jar;
import com.dianping.cat.home.jar.entity.JarReport;
import com.dianping.cat.home.jar.entity.Machine;
import com.dianping.cat.home.jar.transform.IMaker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxMaker
implements IMaker<Attributes> {
    public Domain buildDomain(Attributes attributes) {
        String id = attributes.getValue("id");
        Domain domain = new Domain(id);
        return domain;
    }

    public Jar buildJar(Attributes attributes) {
        String id = attributes.getValue("id");
        String version = attributes.getValue("version");
        Jar jar = new Jar();
        if (id != null) {
            jar.setId(id);
        }
        if (version != null) {
            jar.setVersion(version);
        }
        return jar;
    }

    public JarReport buildJarReport(Attributes attributes) {
        String domain = attributes.getValue("domain");
        String startTime = attributes.getValue("startTime");
        String endTime = attributes.getValue("endTime");
        JarReport jarReport = new JarReport();
        if (domain != null) {
            jarReport.setDomain(domain);
        }
        if (startTime != null) {
            jarReport.setStartTime(this.toDate(startTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (endTime != null) {
            jarReport.setEndTime(this.toDate(endTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        return jarReport;
    }

    public Machine buildMachine(Attributes attributes) {
        String id = attributes.getValue("id");
        Machine machine = new Machine(id);
        return machine;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected Date toDate(String str, String format, Date defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

