/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.network.entity;

import com.dianping.cat.home.network.BaseEntity;
import com.dianping.cat.home.network.IVisitor;
import com.dianping.cat.home.network.entity.NetGraph;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetGraphSet
extends BaseEntity<NetGraphSet> {
    private Map<Integer, NetGraph> m_netGraphs = new LinkedHashMap();

    public void accept(IVisitor visitor) {
        visitor.visitNetGraphSet(this);
    }

    public NetGraphSet addNetGraph(NetGraph netGraph) {
        this.m_netGraphs.put(netGraph.getMinute(), netGraph);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetGraphSet) {
            NetGraphSet _o = (NetGraphSet)obj;
            return this.equals((Object)this.m_netGraphs, (Object)_o.getNetGraphs());
        }
        return false;
    }

    public NetGraph findNetGraph(Integer minute) {
        return (NetGraph)this.m_netGraphs.get(minute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetGraph findOrCreateNetGraph(Integer minute) {
        NetGraph netGraph = (NetGraph)this.m_netGraphs.get(minute);
        if (netGraph == null) {
            Map map = this.m_netGraphs;
            synchronized (map) {
                netGraph = (NetGraph)this.m_netGraphs.get(minute);
                if (netGraph == null) {
                    netGraph = new NetGraph(minute);
                    this.m_netGraphs.put(minute, netGraph);
                }
            }
        }
        return netGraph;
    }

    public Map<Integer, NetGraph> getNetGraphs() {
        return this.m_netGraphs;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_netGraphs == null ? 0 : this.m_netGraphs.hashCode());
        return hash;
    }

    public void mergeAttributes(NetGraphSet other) {
    }

    public NetGraph removeNetGraph(Integer minute) {
        return (NetGraph)this.m_netGraphs.remove(minute);
    }
}

