/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.network.entity;

import com.dianping.cat.home.network.BaseEntity;
import com.dianping.cat.home.network.IVisitor;
import com.dianping.cat.home.network.entity.Anchor;
import com.dianping.cat.home.network.entity.Connection;
import com.dianping.cat.home.network.entity.Switch;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetTopology
extends BaseEntity<NetTopology> {
    private String m_name;
    private List<Anchor> m_anchors = new ArrayList();
    private List<Switch> m_switchs = new ArrayList();
    private List<Connection> m_connections = new ArrayList();

    public void accept(IVisitor visitor) {
        visitor.visitNetTopology(this);
    }

    public NetTopology addAnchor(Anchor anchor) {
        this.m_anchors.add(anchor);
        return this;
    }

    public NetTopology addConnection(Connection connection) {
        this.m_connections.add(connection);
        return this;
    }

    public NetTopology addSwitch(Switch _switch) {
        this.m_switchs.add(_switch);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetTopology) {
            NetTopology _o = (NetTopology)obj;
            if (!this.equals((Object)this.m_name, (Object)_o.getName())) {
                return false;
            }
            if (!this.equals((Object)this.m_anchors, (Object)_o.getAnchors())) {
                return false;
            }
            if (!this.equals((Object)this.m_switchs, (Object)_o.getSwitchs())) {
                return false;
            }
            return this.equals((Object)this.m_connections, (Object)_o.getConnections());
        }
        return false;
    }

    public List<Anchor> getAnchors() {
        return this.m_anchors;
    }

    public List<Connection> getConnections() {
        return this.m_connections;
    }

    public String getName() {
        return this.m_name;
    }

    public List<Switch> getSwitchs() {
        return this.m_switchs;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_name == null ? 0 : this.m_name.hashCode());
        hash = hash * 31 + (this.m_anchors == null ? 0 : this.m_anchors.hashCode());
        hash = hash * 31 + (this.m_switchs == null ? 0 : this.m_switchs.hashCode());
        hash = hash * 31 + (this.m_connections == null ? 0 : this.m_connections.hashCode());
        return hash;
    }

    public void mergeAttributes(NetTopology other) {
        if (other.getName() != null) {
            this.m_name = other.getName();
        }
    }

    public NetTopology setName(String name) {
        this.m_name = name;
        return this;
    }
}

