/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.network.transform;

import com.dianping.cat.home.network.IEntity;
import com.dianping.cat.home.network.IVisitor;
import com.dianping.cat.home.network.entity.Anchor;
import com.dianping.cat.home.network.entity.Connection;
import com.dianping.cat.home.network.entity.Interface;
import com.dianping.cat.home.network.entity.NetGraph;
import com.dianping.cat.home.network.entity.NetGraphSet;
import com.dianping.cat.home.network.entity.NetTopology;
import com.dianping.cat.home.network.entity.Switch;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJsonBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultJsonBuilder() {
        this(false);
    }

    public DefaultJsonBuilder(boolean compact) {
        this(compact, new StringBuilder(4096));
    }

    public DefaultJsonBuilder(boolean compact, StringBuilder sb) {
        this.m_compact = compact;
        this.m_sb = sb;
        this.m_visitor = this;
    }

    protected void arrayBegin(String name) {
        this.indent();
        this.m_sb.append('\"').append(name).append(this.m_compact ? "\":[" : "\": [\r\n");
        ++this.m_level;
    }

    protected void arrayEnd(String name) {
        --this.m_level;
        this.trimComma();
        this.indent();
        this.m_sb.append("],").append(this.m_compact ? "" : "\r\n");
    }

    protected void attributes(Map<String, String> dynamicAttributes, Object ... nameValues) {
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                if (attrValue instanceof List) {
                    List list = (List)attrValue;
                    if (!list.isEmpty()) {
                        this.indent();
                        this.m_sb.append('\"').append(attrName).append(this.m_compact ? "\":[" : "\": [");
                        for (Object item : list) {
                            this.m_sb.append(' ');
                            this.toString(this.m_sb, item);
                            this.m_sb.append(',');
                        }
                        this.m_sb.setLength(this.m_sb.length() - 1);
                        this.m_sb.append(this.m_compact ? "]," : " ],\r\n");
                    }
                } else if (this.m_compact) {
                    this.m_sb.append('\"').append(attrName).append("\":");
                    this.toString(this.m_sb, attrValue);
                    this.m_sb.append(",");
                } else {
                    this.indent();
                    this.m_sb.append('\"').append(attrName).append("\": ");
                    this.toString(this.m_sb, attrValue);
                    this.m_sb.append(",\r\n");
                }
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                if (this.m_compact) {
                    this.m_sb.append('\"').append(e.getKey()).append("\":");
                    this.toString(this.m_sb, (Object)e.getValue());
                    this.m_sb.append(",");
                    continue;
                }
                this.indent();
                this.m_sb.append('\"').append(e.getKey()).append("\": ");
                this.toString(this.m_sb, (Object)e.getValue());
                this.m_sb.append(",\r\n");
            }
        }
    }

    public String build(IEntity<?> entity) {
        this.objectBegin(null);
        entity.accept((IVisitor)this);
        this.objectEnd(null);
        this.trimComma();
        return this.m_sb.toString();
    }

    public String buildArray(Collection<? extends IEntity<?>> entities) {
        this.m_sb.append('[');
        if (entities != null) {
            for (IEntity<?> entity : entities) {
                this.objectBegin(null);
                entity.accept((IVisitor)this);
                this.objectEnd(null);
            }
            this.trimComma();
        }
        this.m_sb.append(']');
        return this.m_sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void objectBegin(String name) {
        this.indent();
        if (name == null) {
            this.m_sb.append("{").append(this.m_compact ? "" : "\r\n");
        } else {
            this.m_sb.append('\"').append(name).append(this.m_compact ? "\":{" : "\": {\r\n");
        }
        ++this.m_level;
    }

    protected void objectEnd(String name) {
        --this.m_level;
        this.trimComma();
        this.indent();
        this.m_sb.append(this.m_compact ? "}," : "},\r\n");
    }

    protected void toString(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof Boolean || value instanceof Number) {
            sb.append(value);
        } else {
            String val = value.toString();
            int len = val.length();
            sb.append('\"');
            block6: for (int i = 0; i < len; ++i) {
                char ch = val.charAt(i);
                switch (ch) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        sb.append('\\').append(ch);
                        continue block6;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block6;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block6;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block6;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            sb.append('\"');
        }
    }

    protected void trimComma() {
        int len = this.m_sb.length();
        if (this.m_compact) {
            if (len > 1 && this.m_sb.charAt(len - 1) == ',') {
                this.m_sb.replace(len - 1, len, "");
            }
        } else if (len > 3 && this.m_sb.charAt(len - 3) == ',') {
            this.m_sb.replace(len - 3, len - 2, "");
        }
    }

    public void visitAnchor(Anchor anchor) {
        this.attributes(null, new Object[]{"name", anchor.getName(), "x", anchor.getX(), "y", anchor.getY()});
    }

    public void visitConnection(Connection connection) {
        this.attributes(null, new Object[]{"from", connection.getFrom(), "to", connection.getTo(), "instate", connection.getInstate(), "outstate", connection.getOutstate(), "insum", connection.getInsum(), "outsum", connection.getOutsum(), "inDiscardsState", connection.getInDiscardsState(), "outDiscardsState", connection.getOutDiscardsState(), "inErrorsState", connection.getInErrorsState(), "outErrorsState", connection.getOutErrorsState(), "inDiscards", connection.getInDiscards(), "outDiscards", connection.getOutDiscards(), "inErrors", connection.getInErrors(), "outErrors", connection.getOutErrors()});
        if (!connection.getInterfaces().isEmpty()) {
            this.arrayBegin("interfaces");
            for (Interface interface_ : connection.getInterfaces()) {
                this.objectBegin(null);
                interface_.accept(this.m_visitor);
                this.objectEnd(null);
            }
            this.arrayEnd("interfaces");
        }
    }

    public void visitInterface(Interface _interface) {
        this.attributes(null, new Object[]{"group", _interface.getGroup(), "domain", _interface.getDomain(), "key", _interface.getKey(), "instate", _interface.getInstate(), "outstate", _interface.getOutstate(), "in", _interface.getIn(), "out", _interface.getOut(), "inDiscardsState", _interface.getInDiscardsState(), "outDiscardsState", _interface.getOutDiscardsState(), "inErrorsState", _interface.getInErrorsState(), "outErrorsState", _interface.getOutErrorsState(), "inDiscards", _interface.getInDiscards(), "outDiscards", _interface.getOutDiscards(), "inErrors", _interface.getInErrors(), "outErrors", _interface.getOutErrors()});
    }

    public void visitNetGraph(NetGraph netGraph) {
        this.attributes(null, new Object[]{"minute", netGraph.getMinute()});
        if (!netGraph.getNetTopologies().isEmpty()) {
            this.arrayBegin("netTopologies");
            for (NetTopology netTopology : netGraph.getNetTopologies()) {
                this.objectBegin(null);
                netTopology.accept(this.m_visitor);
                this.objectEnd(null);
            }
            this.arrayEnd("netTopologies");
        }
    }

    public void visitNetGraphSet(NetGraphSet netGraphSet) {
        if (!netGraphSet.getNetGraphs().isEmpty()) {
            this.objectBegin("netGraphs");
            for (Map.Entry e : netGraphSet.getNetGraphs().entrySet()) {
                String key = String.valueOf(e.getKey());
                this.objectBegin(key);
                ((NetGraph)e.getValue()).accept(this.m_visitor);
                this.objectEnd(key);
            }
            this.objectEnd("netGraphs");
        }
    }

    public void visitNetTopology(NetTopology netTopology) {
        this.attributes(null, new Object[]{"name", netTopology.getName()});
        if (!netTopology.getAnchors().isEmpty()) {
            this.arrayBegin("anchors");
            for (Anchor anchor : netTopology.getAnchors()) {
                this.objectBegin(null);
                anchor.accept(this.m_visitor);
                this.objectEnd(null);
            }
            this.arrayEnd("anchors");
        }
        if (!netTopology.getSwitchs().isEmpty()) {
            this.arrayBegin("switchs");
            for (Switch switch_ : netTopology.getSwitchs()) {
                this.objectBegin(null);
                switch_.accept(this.m_visitor);
                this.objectEnd(null);
            }
            this.arrayEnd("switchs");
        }
        if (!netTopology.getConnections().isEmpty()) {
            this.arrayBegin("connections");
            for (Connection connection : netTopology.getConnections()) {
                this.objectBegin(null);
                connection.accept(this.m_visitor);
                this.objectEnd(null);
            }
            this.arrayEnd("connections");
        }
    }

    public void visitSwitch(Switch _switch) {
        this.attributes(null, new Object[]{"name", _switch.getName(), "x", _switch.getX(), "y", _switch.getY(), "state", _switch.getState()});
    }
}

