/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.network.transform;

import com.dianping.cat.home.network.IEntity;
import com.dianping.cat.home.network.entity.Anchor;
import com.dianping.cat.home.network.entity.Connection;
import com.dianping.cat.home.network.entity.Interface;
import com.dianping.cat.home.network.entity.NetGraph;
import com.dianping.cat.home.network.entity.NetGraphSet;
import com.dianping.cat.home.network.entity.NetTopology;
import com.dianping.cat.home.network.entity.Switch;
import com.dianping.cat.home.network.transform.DefaultJsonParser;
import com.dianping.cat.home.network.transform.DefaultLinker;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DefaultJsonParser {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private List<Object> m_entities = new ArrayList();
    private Class<?> m_entityClass;

    private DefaultJsonParser(Class<?> entityClass) {
        this.m_entityClass = entityClass;
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, InputStream in) throws IOException {
        return (T)DefaultJsonParser.parse(entityClass, (Reader)new InputStreamReader(in, "utf-8"));
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, Reader reader) throws IOException {
        DefaultJsonParser parser = new DefaultJsonParser(entityClass);
        parser.onArrayBegin();
        parser.parse(new JsonReader(reader));
        parser.onArrayEnd();
        if (parser.m_entities.isEmpty()) {
            return null;
        }
        return (T)((IEntity)parser.m_entities.get(0));
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, String json) throws IOException {
        return (T)DefaultJsonParser.parse(entityClass, (Reader)new StringReader(json));
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, InputStream in) throws Exception {
        return DefaultJsonParser.parseArray(entityClass, (Reader)new InputStreamReader(in, "utf-8"));
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, Reader reader) throws Exception {
        DefaultJsonParser parser = new DefaultJsonParser(entityClass);
        parser.parse(new JsonReader(reader));
        return parser.m_entities;
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, String json) throws Exception {
        return DefaultJsonParser.parseArray(entityClass, (Reader)new StringReader(json));
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    private Object createRootEntity() {
        try {
            Object entity = this.m_entityClass.newInstance();
            return entity;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to create entity(%s) instance!", this.m_entityClass.getName()), e);
        }
    }

    private boolean isTopLevel() {
        return this.m_objs.size() == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onArrayBegin() {
        if (this.m_objs.isEmpty()) {
            this.m_objs.push(this.m_entities);
            this.m_tags.push("");
            return;
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof NetGraph) {
                if (!"netTopologies".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                this.m_objs.push(parent);
                return;
            } else if (parent instanceof NetTopology) {
                if ("anchors".equals(tag)) {
                    this.m_objs.push(parent);
                    return;
                } else if ("switchs".equals(tag)) {
                    this.m_objs.push(parent);
                    return;
                } else {
                    if (!"connections".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                    this.m_objs.push(parent);
                }
                return;
            } else {
                if (!(parent instanceof Connection)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                if (!"interfaces".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                this.m_objs.push(parent);
            }
        }
    }

    protected void onArrayEnd() {
        this.m_objs.pop();
        this.m_tags.pop();
    }

    protected void onName(String name) {
        this.m_tags.push(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onObjectBegin() {
        if (this.isTopLevel()) {
            this.m_objs.push(this.createRootEntity());
            this.m_tags.push("");
            return;
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof NetGraphSet) {
                if ("netGraphs".equals(tag)) {
                    this.m_objs.push(parent);
                    return;
                } else {
                    String parentTag;
                    String string = parentTag = this.m_tags.size() >= 2 ? (String)this.m_tags.get(this.m_tags.size() - 2) : null;
                    if (!"netGraphs".equals(parentTag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                    NetGraph netGraphs = new NetGraph();
                    this.m_linker.onNetGraph((NetGraphSet)parent, netGraphs);
                    this.m_objs.push(netGraphs);
                }
                return;
            } else if (parent instanceof NetGraph) {
                if (!"netTopologies".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                NetTopology netTopologies = new NetTopology();
                this.m_linker.onNetTopology((NetGraph)parent, netTopologies);
                this.m_objs.push(netTopologies);
                this.m_tags.push("");
                return;
            } else if (parent instanceof NetTopology) {
                if ("anchors".equals(tag)) {
                    Anchor anchors = new Anchor();
                    this.m_linker.onAnchor((NetTopology)parent, anchors);
                    this.m_objs.push(anchors);
                    this.m_tags.push("");
                    return;
                } else if ("switchs".equals(tag)) {
                    Switch switchs = new Switch();
                    this.m_linker.onSwitch((NetTopology)parent, switchs);
                    this.m_objs.push(switchs);
                    this.m_tags.push("");
                    return;
                } else {
                    if (!"connections".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                    Connection connections = new Connection();
                    this.m_linker.onConnection((NetTopology)parent, connections);
                    this.m_objs.push(connections);
                    this.m_tags.push("");
                }
                return;
            } else {
                if (!(parent instanceof Connection)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                if (!"interfaces".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                Interface interfaces = new Interface();
                this.m_linker.onInterface((Connection)parent, interfaces);
                this.m_objs.push(interfaces);
                this.m_tags.push("");
            }
        }
    }

    protected void onObjectEnd() {
        this.m_tags.pop();
        Object entity = this.m_objs.pop();
        if (this.isTopLevel()) {
            this.m_entities.add(entity);
        }
    }

    protected void onValue(String value) {
        Object parent = this.m_objs.peek();
        String tag = (String)this.m_tags.pop();
        if (parent instanceof NetGraphSet) {
            this.parseForNetGraphSet((NetGraphSet)parent, tag, value);
        } else if (parent instanceof NetGraph) {
            this.parseForNetGraph((NetGraph)parent, tag, value);
        } else if (parent instanceof NetTopology) {
            this.parseForNetTopology((NetTopology)parent, tag, value);
        } else if (parent instanceof Anchor) {
            this.parseForAnchor((Anchor)parent, tag, value);
        } else if (parent instanceof Switch) {
            this.parseForSwitch((Switch)parent, tag, value);
        } else if (parent instanceof Connection) {
            this.parseForConnection((Connection)parent, tag, value);
        } else if (parent instanceof Interface) {
            this.parseForInterface((Interface)parent, tag, value);
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) under %s!", tag, parent));
        }
    }

    private void parse(JsonReader reader) throws IOException {
        block2: {
            try {
                reader.parse(this);
            }
            catch (EOFException e) {
                if (this.m_objs.size() <= 1) break block2;
                throw new EOFException(String.format("Unexpected end while parsing json! tags: %s.", this.m_tags));
            }
        }
        this.m_linker.finish();
    }

    public void parseForAnchor(Anchor anchor, String tag, String value) {
        if ("name".equals(tag)) {
            anchor.setName(value);
        } else if ("x".equals(tag)) {
            anchor.setX((Integer)this.convert(Integer.class, value, null));
        } else if ("y".equals(tag)) {
            anchor.setY((Integer)this.convert(Integer.class, value, null));
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, anchor, this.m_tags));
        }
    }

    public void parseForConnection(Connection connection, String tag, String value) {
        if (!"interfaces".equals(tag)) {
            if ("from".equals(tag)) {
                connection.setFrom(value);
            } else if ("to".equals(tag)) {
                connection.setTo(value);
            } else if ("instate".equals(tag)) {
                connection.setInstate((Integer)this.convert(Integer.class, value, null));
            } else if ("outstate".equals(tag)) {
                connection.setOutstate((Integer)this.convert(Integer.class, value, null));
            } else if ("insum".equals(tag)) {
                connection.setInsum((Double)this.convert(Double.class, value, null));
            } else if ("outsum".equals(tag)) {
                connection.setOutsum((Double)this.convert(Double.class, value, null));
            } else if ("inDiscardsState".equals(tag)) {
                connection.setInDiscardsState((Integer)this.convert(Integer.class, value, null));
            } else if ("outDiscardsState".equals(tag)) {
                connection.setOutDiscardsState((Integer)this.convert(Integer.class, value, null));
            } else if ("inErrorsState".equals(tag)) {
                connection.setInErrorsState((Integer)this.convert(Integer.class, value, null));
            } else if ("outErrorsState".equals(tag)) {
                connection.setOutErrorsState((Integer)this.convert(Integer.class, value, null));
            } else if ("inDiscards".equals(tag)) {
                connection.setInDiscards((Double)this.convert(Double.class, value, null));
            } else if ("outDiscards".equals(tag)) {
                connection.setOutDiscards((Double)this.convert(Double.class, value, null));
            } else if ("inErrors".equals(tag)) {
                connection.setInErrors((Double)this.convert(Double.class, value, null));
            } else if ("outErrors".equals(tag)) {
                connection.setOutErrors((Double)this.convert(Double.class, value, null));
            } else {
                throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, connection, this.m_tags));
            }
        }
    }

    public void parseForInterface(Interface _interface, String tag, String value) {
        if ("group".equals(tag)) {
            _interface.setGroup(value);
        } else if ("domain".equals(tag)) {
            _interface.setDomain(value);
        } else if ("key".equals(tag)) {
            _interface.setKey(value);
        } else if ("instate".equals(tag)) {
            _interface.setInstate((Integer)this.convert(Integer.class, value, null));
        } else if ("outstate".equals(tag)) {
            _interface.setOutstate((Integer)this.convert(Integer.class, value, null));
        } else if ("in".equals(tag)) {
            _interface.setIn((Double)this.convert(Double.class, value, null));
        } else if ("out".equals(tag)) {
            _interface.setOut((Double)this.convert(Double.class, value, null));
        } else if ("inDiscardsState".equals(tag)) {
            _interface.setInDiscardsState((Integer)this.convert(Integer.class, value, null));
        } else if ("outDiscardsState".equals(tag)) {
            _interface.setOutDiscardsState((Integer)this.convert(Integer.class, value, null));
        } else if ("inErrorsState".equals(tag)) {
            _interface.setInErrorsState((Integer)this.convert(Integer.class, value, null));
        } else if ("outErrorsState".equals(tag)) {
            _interface.setOutErrorsState((Integer)this.convert(Integer.class, value, null));
        } else if ("inDiscards".equals(tag)) {
            _interface.setInDiscards((Double)this.convert(Double.class, value, null));
        } else if ("outDiscards".equals(tag)) {
            _interface.setOutDiscards((Double)this.convert(Double.class, value, null));
        } else if ("inErrors".equals(tag)) {
            _interface.setInErrors((Double)this.convert(Double.class, value, null));
        } else if ("outErrors".equals(tag)) {
            _interface.setOutErrors((Double)this.convert(Double.class, value, null));
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, _interface, this.m_tags));
        }
    }

    public void parseForNetGraph(NetGraph netGraph, String tag, String value) {
        if (!"netTopologies".equals(tag)) {
            if ("minute".equals(tag)) {
                netGraph.setMinute((Integer)this.convert(Integer.class, value, null));
            } else {
                throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, netGraph, this.m_tags));
            }
        }
    }

    public void parseForNetGraphSet(NetGraphSet netGraphSet, String tag, String value) {
        if (!"netGraphs".equals(tag)) {
            throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, netGraphSet, this.m_tags));
        }
    }

    public void parseForNetTopology(NetTopology netTopology, String tag, String value) {
        if (!("anchors".equals(tag) || "switchs".equals(tag) || "connections".equals(tag))) {
            if ("name".equals(tag)) {
                netTopology.setName(value);
            } else {
                throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, netTopology, this.m_tags));
            }
        }
    }

    public void parseForSwitch(Switch _switch, String tag, String value) {
        if ("name".equals(tag)) {
            _switch.setName(value);
        } else if ("x".equals(tag)) {
            _switch.setX((Integer)this.convert(Integer.class, value, null));
        } else if ("y".equals(tag)) {
            _switch.setY((Integer)this.convert(Integer.class, value, null));
        } else if ("state".equals(tag)) {
            _switch.setState((Integer)this.convert(Integer.class, value, null));
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, _switch, this.m_tags));
        }
    }
}

