/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.network.transform;

import com.dianping.cat.home.network.IEntity;
import com.dianping.cat.home.network.IVisitor;
import com.dianping.cat.home.network.entity.Anchor;
import com.dianping.cat.home.network.entity.Connection;
import com.dianping.cat.home.network.entity.Interface;
import com.dianping.cat.home.network.entity.NetGraph;
import com.dianping.cat.home.network.entity.NetGraphSet;
import com.dianping.cat.home.network.entity.NetTopology;
import com.dianping.cat.home.network.entity.Switch;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private NetGraphSet m_netGraphSet;

    public DefaultMerger() {
    }

    public DefaultMerger(NetGraphSet netGraphSet) {
        this.m_netGraphSet = netGraphSet;
        this.m_objs.push(netGraphSet);
    }

    public NetGraphSet getNetGraphSet() {
        return this.m_netGraphSet;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeAnchor(Anchor to, Anchor from) {
        to.mergeAttributes(from);
    }

    protected void mergeConnection(Connection to, Connection from) {
        to.mergeAttributes(from);
    }

    protected void mergeInterface(Interface to, Interface from) {
        to.mergeAttributes(from);
    }

    protected void mergeNetGraph(NetGraph to, NetGraph from) {
        to.mergeAttributes(from);
    }

    protected void mergeNetGraphSet(NetGraphSet to, NetGraphSet from) {
        to.mergeAttributes(from);
    }

    protected void mergeNetTopology(NetTopology to, NetTopology from) {
        to.mergeAttributes(from);
    }

    protected void mergeSwitch(Switch to, Switch from) {
        to.mergeAttributes(from);
    }

    public void visitAnchor(Anchor from) {
        Anchor to = (Anchor)this.m_objs.peek();
        this.mergeAnchor(to, from);
        this.visitAnchorChildren(to, from);
    }

    protected void visitAnchorChildren(Anchor to, Anchor from) {
    }

    public void visitConnection(Connection from) {
        Connection to = (Connection)this.m_objs.peek();
        this.mergeConnection(to, from);
        this.visitConnectionChildren(to, from);
    }

    protected void visitConnectionChildren(Connection to, Connection from) {
        for (Interface source : from.getInterfaces()) {
            Interface target = null;
            if (target == null) {
                target = new Interface();
                to.addInterface(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitInterface(Interface from) {
        Interface to = (Interface)this.m_objs.peek();
        this.mergeInterface(to, from);
        this.visitInterfaceChildren(to, from);
    }

    protected void visitInterfaceChildren(Interface to, Interface from) {
    }

    public void visitNetGraph(NetGraph from) {
        NetGraph to = (NetGraph)this.m_objs.peek();
        this.mergeNetGraph(to, from);
        this.visitNetGraphChildren(to, from);
    }

    protected void visitNetGraphChildren(NetGraph to, NetGraph from) {
        for (NetTopology source : from.getNetTopologies()) {
            NetTopology target = null;
            if (target == null) {
                target = new NetTopology();
                to.addNetTopology(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitNetGraphSet(NetGraphSet from) {
        NetGraphSet to = (NetGraphSet)this.m_objs.peek();
        this.mergeNetGraphSet(to, from);
        this.visitNetGraphSetChildren(to, from);
    }

    protected void visitNetGraphSetChildren(NetGraphSet to, NetGraphSet from) {
        for (NetGraph source : from.getNetGraphs().values()) {
            NetGraph target = to.findNetGraph(source.getMinute());
            if (target == null) {
                target = new NetGraph(source.getMinute());
                to.addNetGraph(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitNetTopology(NetTopology from) {
        NetTopology to = (NetTopology)this.m_objs.peek();
        this.mergeNetTopology(to, from);
        this.visitNetTopologyChildren(to, from);
    }

    protected void visitNetTopologyChildren(NetTopology to, NetTopology from) {
        Anchor target;
        for (Anchor source : from.getAnchors()) {
            target = null;
            if (target == null) {
                target = new Anchor();
                to.addAnchor(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (Anchor source : from.getSwitchs()) {
            target = null;
            if (target == null) {
                target = new Switch();
                to.addSwitch((Switch)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (Anchor source : from.getConnections()) {
            target = null;
            if (target == null) {
                target = new Connection();
                to.addConnection((Connection)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitSwitch(Switch from) {
        Switch to = (Switch)this.m_objs.peek();
        this.mergeSwitch(to, from);
        this.visitSwitchChildren(to, from);
    }

    protected void visitSwitchChildren(Switch to, Switch from) {
    }
}

