/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.network.transform;

import com.dianping.cat.home.network.IVisitor;
import com.dianping.cat.home.network.entity.Anchor;
import com.dianping.cat.home.network.entity.Connection;
import com.dianping.cat.home.network.entity.Interface;
import com.dianping.cat.home.network.entity.NetGraph;
import com.dianping.cat.home.network.entity.NetGraphSet;
import com.dianping.cat.home.network.entity.NetTopology;
import com.dianping.cat.home.network.entity.Switch;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private DataOutputStream m_out;

    public DefaultNativeBuilder(OutputStream out) {
        this(out, null);
    }

    public DefaultNativeBuilder(OutputStream out, IVisitor visitor) {
        this.m_out = new DataOutputStream(out);
        this.m_visitor = visitor == null ? this : visitor;
    }

    public static byte[] build(NetGraphSet netGraphSet) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DefaultNativeBuilder.build((NetGraphSet)netGraphSet, (OutputStream)out);
        return out.toByteArray();
    }

    public static void build(NetGraphSet netGraphSet, OutputStream out) {
        netGraphSet.accept((IVisitor)new DefaultNativeBuilder(out));
    }

    public void visitAnchor(Anchor anchor) {
        if (anchor.getName() != null) {
            this.writeTag(1, 1);
            this.writeString(anchor.getName());
        }
        if (anchor.getX() != null) {
            this.writeTag(2, 1);
            this.writeInt(anchor.getX().intValue());
        }
        if (anchor.getY() != null) {
            this.writeTag(3, 1);
            this.writeInt(anchor.getY().intValue());
        }
        this.writeTag(63, 3);
    }

    public void visitConnection(Connection connection) {
        if (connection.getFrom() != null) {
            this.writeTag(1, 1);
            this.writeString(connection.getFrom());
        }
        if (connection.getTo() != null) {
            this.writeTag(2, 1);
            this.writeString(connection.getTo());
        }
        if (connection.getInstate() != null) {
            this.writeTag(3, 1);
            this.writeInt(connection.getInstate().intValue());
        }
        if (connection.getOutstate() != null) {
            this.writeTag(4, 1);
            this.writeInt(connection.getOutstate().intValue());
        }
        if (connection.getInsum() != null) {
            this.writeTag(5, 1);
            this.writeDouble(connection.getInsum().doubleValue());
        }
        if (connection.getOutsum() != null) {
            this.writeTag(6, 1);
            this.writeDouble(connection.getOutsum().doubleValue());
        }
        if (connection.getInDiscardsState() != null) {
            this.writeTag(7, 1);
            this.writeInt(connection.getInDiscardsState().intValue());
        }
        if (connection.getOutDiscardsState() != null) {
            this.writeTag(8, 1);
            this.writeInt(connection.getOutDiscardsState().intValue());
        }
        if (connection.getInErrorsState() != null) {
            this.writeTag(9, 1);
            this.writeInt(connection.getInErrorsState().intValue());
        }
        if (connection.getOutErrorsState() != null) {
            this.writeTag(10, 1);
            this.writeInt(connection.getOutErrorsState().intValue());
        }
        if (connection.getInDiscards() != null) {
            this.writeTag(11, 1);
            this.writeDouble(connection.getInDiscards().doubleValue());
        }
        if (connection.getOutDiscards() != null) {
            this.writeTag(12, 1);
            this.writeDouble(connection.getOutDiscards().doubleValue());
        }
        if (connection.getInErrors() != null) {
            this.writeTag(13, 1);
            this.writeDouble(connection.getInErrors().doubleValue());
        }
        if (connection.getOutErrors() != null) {
            this.writeTag(14, 1);
            this.writeDouble(connection.getOutErrors().doubleValue());
        }
        if (!connection.getInterfaces().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(connection.getInterfaces().size());
            for (Interface interface_ : connection.getInterfaces()) {
                interface_.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitInterface(Interface _interface) {
        if (_interface.getGroup() != null) {
            this.writeTag(1, 1);
            this.writeString(_interface.getGroup());
        }
        if (_interface.getDomain() != null) {
            this.writeTag(2, 1);
            this.writeString(_interface.getDomain());
        }
        if (_interface.getKey() != null) {
            this.writeTag(3, 1);
            this.writeString(_interface.getKey());
        }
        if (_interface.getInstate() != null) {
            this.writeTag(4, 1);
            this.writeInt(_interface.getInstate().intValue());
        }
        if (_interface.getOutstate() != null) {
            this.writeTag(5, 1);
            this.writeInt(_interface.getOutstate().intValue());
        }
        if (_interface.getIn() != null) {
            this.writeTag(6, 1);
            this.writeDouble(_interface.getIn().doubleValue());
        }
        if (_interface.getOut() != null) {
            this.writeTag(7, 1);
            this.writeDouble(_interface.getOut().doubleValue());
        }
        if (_interface.getInDiscardsState() != null) {
            this.writeTag(8, 1);
            this.writeInt(_interface.getInDiscardsState().intValue());
        }
        if (_interface.getOutDiscardsState() != null) {
            this.writeTag(9, 1);
            this.writeInt(_interface.getOutDiscardsState().intValue());
        }
        if (_interface.getInErrorsState() != null) {
            this.writeTag(10, 1);
            this.writeInt(_interface.getInErrorsState().intValue());
        }
        if (_interface.getOutErrorsState() != null) {
            this.writeTag(11, 1);
            this.writeInt(_interface.getOutErrorsState().intValue());
        }
        if (_interface.getInDiscards() != null) {
            this.writeTag(12, 1);
            this.writeDouble(_interface.getInDiscards().doubleValue());
        }
        if (_interface.getOutDiscards() != null) {
            this.writeTag(13, 1);
            this.writeDouble(_interface.getOutDiscards().doubleValue());
        }
        if (_interface.getInErrors() != null) {
            this.writeTag(14, 1);
            this.writeDouble(_interface.getInErrors().doubleValue());
        }
        if (_interface.getOutErrors() != null) {
            this.writeTag(15, 1);
            this.writeDouble(_interface.getOutErrors().doubleValue());
        }
        this.writeTag(63, 3);
    }

    public void visitNetGraph(NetGraph netGraph) {
        if (netGraph.getMinute() != null) {
            this.writeTag(1, 1);
            this.writeInt(netGraph.getMinute().intValue());
        }
        if (!netGraph.getNetTopologies().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(netGraph.getNetTopologies().size());
            for (NetTopology netTopology : netGraph.getNetTopologies()) {
                netTopology.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitNetGraphSet(NetGraphSet netGraphSet) {
        this.writeTag(63, 0);
        if (!netGraphSet.getNetGraphs().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(netGraphSet.getNetGraphs().size());
            for (NetGraph netGraph : netGraphSet.getNetGraphs().values()) {
                netGraph.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitNetTopology(NetTopology netTopology) {
        if (netTopology.getName() != null) {
            this.writeTag(1, 1);
            this.writeString(netTopology.getName());
        }
        if (!netTopology.getAnchors().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(netTopology.getAnchors().size());
            for (Anchor anchor : netTopology.getAnchors()) {
                anchor.accept(this.m_visitor);
            }
        }
        if (!netTopology.getSwitchs().isEmpty()) {
            this.writeTag(34, 2);
            this.writeInt(netTopology.getSwitchs().size());
            for (Switch switch_ : netTopology.getSwitchs()) {
                switch_.accept(this.m_visitor);
            }
        }
        if (!netTopology.getConnections().isEmpty()) {
            this.writeTag(35, 2);
            this.writeInt(netTopology.getConnections().size());
            for (Connection connection : netTopology.getConnections()) {
                connection.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitSwitch(Switch _switch) {
        if (_switch.getName() != null) {
            this.writeTag(1, 1);
            this.writeString(_switch.getName());
        }
        if (_switch.getX() != null) {
            this.writeTag(2, 1);
            this.writeInt(_switch.getX().intValue());
        }
        if (_switch.getY() != null) {
            this.writeTag(3, 1);
            this.writeInt(_switch.getY().intValue());
        }
        if (_switch.getState() != null) {
            this.writeTag(4, 1);
            this.writeInt(_switch.getState().intValue());
        }
        this.writeTag(63, 3);
    }

    private void writeDouble(double value) {
        try {
            this.writeVarint(Double.doubleToLongBits(value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeInt(int value) {
        try {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String value) {
        try {
            this.m_out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(int field, int type) {
        try {
            this.m_out.writeByte((field << 2) + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVarint(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.m_out.writeByte((byte)value);
                return;
            }
            this.m_out.writeByte((byte)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }
}

