/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.network.transform;

import com.dianping.cat.home.network.IVisitor;
import com.dianping.cat.home.network.entity.Anchor;
import com.dianping.cat.home.network.entity.Connection;
import com.dianping.cat.home.network.entity.Interface;
import com.dianping.cat.home.network.entity.NetGraph;
import com.dianping.cat.home.network.entity.NetGraphSet;
import com.dianping.cat.home.network.entity.NetTopology;
import com.dianping.cat.home.network.entity.Switch;
import com.dianping.cat.home.network.transform.DefaultLinker;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeParser
implements IVisitor {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DataInputStream m_in;

    public DefaultNativeParser(InputStream in) {
        this.m_in = new DataInputStream(in);
    }

    public static NetGraphSet parse(byte[] data) {
        return DefaultNativeParser.parse((InputStream)new ByteArrayInputStream(data));
    }

    public static NetGraphSet parse(InputStream in) {
        NetGraphSet netGraphSet;
        DefaultNativeParser parser;
        block2: {
            parser = new DefaultNativeParser(in);
            netGraphSet = new NetGraphSet();
            try {
                netGraphSet.accept((IVisitor)parser);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
        parser.m_linker.finish();
        return netGraphSet;
    }

    public void visitAnchor(Anchor anchor) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitAnchorChildren(anchor, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitAnchorChildren(Anchor anchor, int _field, int _type) {
        switch (_field) {
            case 1: {
                anchor.setName(this.readString());
                break;
            }
            case 2: {
                anchor.setX(Integer.valueOf(this.readInt()));
                break;
            }
            case 3: {
                anchor.setY(Integer.valueOf(this.readInt()));
            }
        }
    }

    public void visitConnection(Connection connection) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitConnectionChildren(connection, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitConnectionChildren(Connection connection, int _field, int _type) {
        switch (_field) {
            case 1: {
                connection.setFrom(this.readString());
                break;
            }
            case 2: {
                connection.setTo(this.readString());
                break;
            }
            case 3: {
                connection.setInstate(Integer.valueOf(this.readInt()));
                break;
            }
            case 4: {
                connection.setOutstate(Integer.valueOf(this.readInt()));
                break;
            }
            case 5: {
                connection.setInsum(Double.valueOf(this.readDouble()));
                break;
            }
            case 6: {
                connection.setOutsum(Double.valueOf(this.readDouble()));
                break;
            }
            case 7: {
                connection.setInDiscardsState(Integer.valueOf(this.readInt()));
                break;
            }
            case 8: {
                connection.setOutDiscardsState(Integer.valueOf(this.readInt()));
                break;
            }
            case 9: {
                connection.setInErrorsState(Integer.valueOf(this.readInt()));
                break;
            }
            case 10: {
                connection.setOutErrorsState(Integer.valueOf(this.readInt()));
                break;
            }
            case 11: {
                connection.setInDiscards(Double.valueOf(this.readDouble()));
                break;
            }
            case 12: {
                connection.setOutDiscards(Double.valueOf(this.readDouble()));
                break;
            }
            case 13: {
                connection.setInErrors(Double.valueOf(this.readDouble()));
                break;
            }
            case 14: {
                connection.setOutErrors(Double.valueOf(this.readDouble()));
                break;
            }
            case 33: {
                if (_type == 1) {
                    Interface interfaces = new Interface();
                    this.visitInterface(interfaces);
                    this.m_linker.onInterface(connection, interfaces);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Interface interfaces = new Interface();
                    this.visitInterface(interfaces);
                    this.m_linker.onInterface(connection, interfaces);
                }
                break;
            }
        }
    }

    public void visitInterface(Interface _interface) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitInterfaceChildren(_interface, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitInterfaceChildren(Interface _interface, int _field, int _type) {
        switch (_field) {
            case 1: {
                _interface.setGroup(this.readString());
                break;
            }
            case 2: {
                _interface.setDomain(this.readString());
                break;
            }
            case 3: {
                _interface.setKey(this.readString());
                break;
            }
            case 4: {
                _interface.setInstate(Integer.valueOf(this.readInt()));
                break;
            }
            case 5: {
                _interface.setOutstate(Integer.valueOf(this.readInt()));
                break;
            }
            case 6: {
                _interface.setIn(Double.valueOf(this.readDouble()));
                break;
            }
            case 7: {
                _interface.setOut(Double.valueOf(this.readDouble()));
                break;
            }
            case 8: {
                _interface.setInDiscardsState(Integer.valueOf(this.readInt()));
                break;
            }
            case 9: {
                _interface.setOutDiscardsState(Integer.valueOf(this.readInt()));
                break;
            }
            case 10: {
                _interface.setInErrorsState(Integer.valueOf(this.readInt()));
                break;
            }
            case 11: {
                _interface.setOutErrorsState(Integer.valueOf(this.readInt()));
                break;
            }
            case 12: {
                _interface.setInDiscards(Double.valueOf(this.readDouble()));
                break;
            }
            case 13: {
                _interface.setOutDiscards(Double.valueOf(this.readDouble()));
                break;
            }
            case 14: {
                _interface.setInErrors(Double.valueOf(this.readDouble()));
                break;
            }
            case 15: {
                _interface.setOutErrors(Double.valueOf(this.readDouble()));
            }
        }
    }

    public void visitNetGraph(NetGraph netGraph) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitNetGraphChildren(netGraph, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitNetGraphChildren(NetGraph netGraph, int _field, int _type) {
        switch (_field) {
            case 1: {
                netGraph.setMinute(Integer.valueOf(this.readInt()));
                break;
            }
            case 33: {
                if (_type == 1) {
                    NetTopology netTopologies = new NetTopology();
                    this.visitNetTopology(netTopologies);
                    this.m_linker.onNetTopology(netGraph, netTopologies);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    NetTopology netTopologies = new NetTopology();
                    this.visitNetTopology(netTopologies);
                    this.m_linker.onNetTopology(netGraph, netTopologies);
                }
                break;
            }
        }
    }

    public void visitNetGraphSet(NetGraphSet netGraphSet) {
        byte tag = this.readTag();
        if (tag != -4) {
            throw new RuntimeException(String.format("Malformed payload, expected: %s, but was: %s!", -4, tag));
        }
        while ((tag = this.readTag()) != -1) {
            this.visitNetGraphSetChildren(netGraphSet, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitNetGraphSetChildren(NetGraphSet netGraphSet, int _field, int _type) {
        switch (_field) {
            case 33: {
                if (_type == 1) {
                    NetGraph netGraphs = new NetGraph();
                    this.visitNetGraph(netGraphs);
                    this.m_linker.onNetGraph(netGraphSet, netGraphs);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    NetGraph netGraphs = new NetGraph();
                    this.visitNetGraph(netGraphs);
                    this.m_linker.onNetGraph(netGraphSet, netGraphs);
                }
                break;
            }
        }
    }

    public void visitNetTopology(NetTopology netTopology) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitNetTopologyChildren(netTopology, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitNetTopologyChildren(NetTopology netTopology, int _field, int _type) {
        switch (_field) {
            case 1: {
                netTopology.setName(this.readString());
                break;
            }
            case 33: {
                if (_type == 1) {
                    Anchor anchors = new Anchor();
                    this.visitAnchor(anchors);
                    this.m_linker.onAnchor(netTopology, anchors);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Anchor anchors = new Anchor();
                    this.visitAnchor(anchors);
                    this.m_linker.onAnchor(netTopology, anchors);
                }
                break;
            }
            case 34: {
                if (_type == 1) {
                    Switch switchs = new Switch();
                    this.visitSwitch(switchs);
                    this.m_linker.onSwitch(netTopology, switchs);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Switch switchs = new Switch();
                    this.visitSwitch(switchs);
                    this.m_linker.onSwitch(netTopology, switchs);
                }
                break;
            }
            case 35: {
                if (_type == 1) {
                    Connection connections = new Connection();
                    this.visitConnection(connections);
                    this.m_linker.onConnection(netTopology, connections);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Connection connections = new Connection();
                    this.visitConnection(connections);
                    this.m_linker.onConnection(netTopology, connections);
                }
                break;
            }
        }
    }

    public void visitSwitch(Switch _switch) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitSwitchChildren(_switch, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitSwitchChildren(Switch _switch, int _field, int _type) {
        switch (_field) {
            case 1: {
                _switch.setName(this.readString());
                break;
            }
            case 2: {
                _switch.setX(Integer.valueOf(this.readInt()));
                break;
            }
            case 3: {
                _switch.setY(Integer.valueOf(this.readInt()));
                break;
            }
            case 4: {
                _switch.setState(Integer.valueOf(this.readInt()));
            }
        }
    }

    private double readDouble() {
        try {
            return Double.longBitsToDouble(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readInt() {
        try {
            return (int)this.readVarint(32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readString() {
        try {
            return this.m_in.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte readTag() {
        try {
            return this.m_in.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected long readVarint(int length) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < length; shift += 7) {
            byte b = this.m_in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("Malformed variable int " + length + "!");
    }
}

