/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.network.transform;

import com.dianping.cat.home.network.IEntity;
import com.dianping.cat.home.network.entity.Anchor;
import com.dianping.cat.home.network.entity.Connection;
import com.dianping.cat.home.network.entity.Interface;
import com.dianping.cat.home.network.entity.NetGraph;
import com.dianping.cat.home.network.entity.NetGraphSet;
import com.dianping.cat.home.network.entity.NetTopology;
import com.dianping.cat.home.network.entity.Switch;
import com.dianping.cat.home.network.transform.DefaultLinker;
import com.dianping.cat.home.network.transform.DefaultSaxMaker;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static NetGraphSet parse(InputSource is) throws SAXException, IOException {
        return (NetGraphSet)DefaultSaxParser.parseEntity(NetGraphSet.class, (InputSource)is);
    }

    public static NetGraphSet parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(in));
    }

    public static NetGraphSet parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(reader));
    }

    public static NetGraphSet parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            this.m_objs.pop();
            this.m_tags.pop();
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForAnchor(Anchor parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForConnection(Connection parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"interface".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under connection!", qName));
        }
        Interface interface_ = this.m_maker.buildInterface(attributes);
        this.m_linker.onInterface(parentObj, interface_);
        this.m_objs.push(interface_);
        this.m_tags.push(qName);
    }

    private void parseForInterface(Interface parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForNetGraph(NetGraph parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"netTopology".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under netGraph!", qName));
        }
        NetTopology netTopology = this.m_maker.buildNetTopology(attributes);
        this.m_linker.onNetTopology(parentObj, netTopology);
        this.m_objs.push(netTopology);
        this.m_tags.push(qName);
    }

    private void parseForNetGraphSet(NetGraphSet parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"netGraph".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under netGraphSet!", qName));
        }
        NetGraph netGraph = this.m_maker.buildNetGraph(attributes);
        this.m_linker.onNetGraph(parentObj, netGraph);
        this.m_objs.push(netGraph);
        this.m_tags.push(qName);
    }

    private void parseForNetTopology(NetTopology parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("anchors".equals(qName) || "switchs".equals(qName) || "connections".equals(qName)) {
            this.m_objs.push(parentObj);
        } else if ("anchor".equals(qName)) {
            Anchor anchor = this.m_maker.buildAnchor(attributes);
            this.m_linker.onAnchor(parentObj, anchor);
            this.m_objs.push(anchor);
        } else if ("switch".equals(qName)) {
            Switch switch_ = this.m_maker.buildSwitch(attributes);
            this.m_linker.onSwitch(parentObj, switch_);
            this.m_objs.push(switch_);
        } else if ("connection".equals(qName)) {
            Connection connection = this.m_maker.buildConnection(attributes);
            this.m_linker.onConnection(parentObj, connection);
            this.m_objs.push(connection);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under netTopology!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForSwitch(Switch parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("netGraphSet".equals(qName)) {
            NetGraphSet netGraphSet = this.m_maker.buildNetGraphSet(attributes);
            this.m_entity = netGraphSet;
            this.m_objs.push(netGraphSet);
            this.m_tags.push(qName);
        } else if ("netGraph".equals(qName)) {
            NetGraph netGraph = this.m_maker.buildNetGraph(attributes);
            this.m_entity = netGraph;
            this.m_objs.push(netGraph);
            this.m_tags.push(qName);
        } else if ("netTopology".equals(qName)) {
            NetTopology netTopology = this.m_maker.buildNetTopology(attributes);
            this.m_entity = netTopology;
            this.m_objs.push(netTopology);
            this.m_tags.push(qName);
        } else if ("anchor".equals(qName)) {
            Anchor anchor = this.m_maker.buildAnchor(attributes);
            this.m_entity = anchor;
            this.m_objs.push(anchor);
            this.m_tags.push(qName);
        } else if ("switch".equals(qName)) {
            Switch _switch = this.m_maker.buildSwitch(attributes);
            this.m_entity = _switch;
            this.m_objs.push(_switch);
            this.m_tags.push(qName);
        } else if ("connection".equals(qName)) {
            Connection connection = this.m_maker.buildConnection(attributes);
            this.m_entity = connection;
            this.m_objs.push(connection);
            this.m_tags.push(qName);
        } else if ("interface".equals(qName)) {
            Interface _interface = this.m_maker.buildInterface(attributes);
            this.m_entity = _interface;
            this.m_objs.push(_interface);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof NetGraphSet) {
                this.parseForNetGraphSet((NetGraphSet)parent, tag, qName, attributes);
            } else if (parent instanceof NetGraph) {
                this.parseForNetGraph((NetGraph)parent, tag, qName, attributes);
            } else if (parent instanceof NetTopology) {
                this.parseForNetTopology((NetTopology)parent, tag, qName, attributes);
            } else if (parent instanceof Anchor) {
                this.parseForAnchor((Anchor)parent, tag, qName, attributes);
            } else if (parent instanceof Switch) {
                this.parseForSwitch((Switch)parent, tag, qName, attributes);
            } else if (parent instanceof Connection) {
                this.parseForConnection((Connection)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof Interface)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForInterface((Interface)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

