/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.network.transform;

import com.dianping.cat.home.network.IEntity;
import com.dianping.cat.home.network.IVisitor;
import com.dianping.cat.home.network.entity.Anchor;
import com.dianping.cat.home.network.entity.Connection;
import com.dianping.cat.home.network.entity.Interface;
import com.dianping.cat.home.network.entity.NetGraph;
import com.dianping.cat.home.network.entity.NetGraphSet;
import com.dianping.cat.home.network.entity.NetTopology;
import com.dianping.cat.home.network.entity.Switch;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXmlBuilder
implements IVisitor {
    private IVisitor m_visitor = this;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultXmlBuilder() {
        this(false);
    }

    public DefaultXmlBuilder(boolean compact) {
        this(compact, new StringBuilder(4096));
    }

    public DefaultXmlBuilder(boolean compact, StringBuilder sb) {
        this.m_compact = compact;
        this.m_sb = sb;
        this.m_sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
    }

    public String buildXml(IEntity<?> entity) {
        entity.accept(this.m_visitor);
        return this.m_sb.toString();
    }

    protected void endTag(String name) {
        --this.m_level;
        this.indent();
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected String escape(Object value) {
        return this.escape(value, false);
    }

    protected String escape(Object value, boolean text) {
        if (value == null) {
            return null;
        }
        String str = value.toString();
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 16);
        block6: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (!text) {
                        sb.append("&quot;");
                        continue block6;
                    }
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void startTag(String name) {
        this.startTag(name, false, null, new Object[0]);
    }

    protected void startTag(String name, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, null, closed, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, null, false, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Object text, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                this.m_sb.append(' ').append(e.getKey()).append("=\"").append(this.escape((Object)e.getValue())).append('\"');
            }
        }
        if (text != null && closed) {
            this.m_sb.append('>');
            this.m_sb.append(this.escape(text, true));
            this.m_sb.append("</").append(name).append(">\r\n");
        } else {
            if (closed) {
                this.m_sb.append('/');
            } else {
                ++this.m_level;
            }
            this.m_sb.append(">\r\n");
        }
    }

    public void visitAnchor(Anchor anchor) {
        this.startTag("anchor", true, null, new Object[]{"name", anchor.getName(), "x", anchor.getX(), "y", anchor.getY()});
    }

    public void visitConnection(Connection connection) {
        this.startTag("connection", null, new Object[]{"from", connection.getFrom(), "to", connection.getTo(), "instate", connection.getInstate(), "outstate", connection.getOutstate(), "insum", connection.getInsum(), "outsum", connection.getOutsum(), "inDiscardsState", connection.getInDiscardsState(), "outDiscardsState", connection.getOutDiscardsState(), "inErrorsState", connection.getInErrorsState(), "outErrorsState", connection.getOutErrorsState(), "inDiscards", connection.getInDiscards(), "outDiscards", connection.getOutDiscards(), "inErrors", connection.getInErrors(), "outErrors", connection.getOutErrors()});
        if (!connection.getInterfaces().isEmpty()) {
            for (Interface interface_ : connection.getInterfaces()) {
                interface_.accept(this.m_visitor);
            }
        }
        this.endTag("connection");
    }

    public void visitInterface(Interface _interface) {
        this.startTag("interface", true, null, new Object[]{"group", _interface.getGroup(), "domain", _interface.getDomain(), "key", _interface.getKey(), "instate", _interface.getInstate(), "outstate", _interface.getOutstate(), "in", _interface.getIn(), "out", _interface.getOut(), "inDiscardsState", _interface.getInDiscardsState(), "outDiscardsState", _interface.getOutDiscardsState(), "inErrorsState", _interface.getInErrorsState(), "outErrorsState", _interface.getOutErrorsState(), "inDiscards", _interface.getInDiscards(), "outDiscards", _interface.getOutDiscards(), "inErrors", _interface.getInErrors(), "outErrors", _interface.getOutErrors()});
    }

    public void visitNetGraph(NetGraph netGraph) {
        this.startTag("netGraph", null, new Object[]{"minute", netGraph.getMinute()});
        if (!netGraph.getNetTopologies().isEmpty()) {
            for (NetTopology netTopology : netGraph.getNetTopologies()) {
                netTopology.accept(this.m_visitor);
            }
        }
        this.endTag("netGraph");
    }

    public void visitNetGraphSet(NetGraphSet netGraphSet) {
        this.startTag("netGraphSet", null, new Object[0]);
        if (!netGraphSet.getNetGraphs().isEmpty()) {
            for (NetGraph netGraph : netGraphSet.getNetGraphs().values()) {
                netGraph.accept(this.m_visitor);
            }
        }
        this.endTag("netGraphSet");
    }

    public void visitNetTopology(NetTopology netTopology) {
        this.startTag("netTopology", null, new Object[]{"name", netTopology.getName()});
        if (!netTopology.getAnchors().isEmpty()) {
            this.startTag("anchors");
            for (Anchor anchor : netTopology.getAnchors()) {
                anchor.accept(this.m_visitor);
            }
            this.endTag("anchors");
        }
        if (!netTopology.getSwitchs().isEmpty()) {
            this.startTag("switchs");
            for (Switch switch_ : netTopology.getSwitchs()) {
                switch_.accept(this.m_visitor);
            }
            this.endTag("switchs");
        }
        if (!netTopology.getConnections().isEmpty()) {
            this.startTag("connections");
            for (Connection connection : netTopology.getConnections()) {
                connection.accept(this.m_visitor);
            }
            this.endTag("connections");
        }
        this.endTag("netTopology");
    }

    public void visitSwitch(Switch _switch) {
        this.startTag("switch", true, null, new Object[]{"name", _switch.getName(), "x", _switch.getX(), "y", _switch.getY(), "state", _switch.getState()});
    }
}

