/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.entity;

import com.dianping.cat.home.router.BaseEntity;
import com.dianping.cat.home.router.IVisitor;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterConfig
extends BaseEntity<RouterConfig> {
    private List<DefaultServer> m_defaultServers = new ArrayList();
    private Map<String, Domain> m_domains = new LinkedHashMap();
    private Date m_startTime;
    private String m_domain;
    private String m_backupServer;
    private int m_backupServerPort;
    private Date m_endTime;

    public RouterConfig() {
    }

    public RouterConfig(String domain) {
        this.m_domain = domain;
    }

    public void accept(IVisitor visitor) {
        visitor.visitRouterConfig(this);
    }

    public RouterConfig addDefaultServer(DefaultServer defaultServer) {
        this.m_defaultServers.add(defaultServer);
        return this;
    }

    public RouterConfig addDomain(Domain domain) {
        this.m_domains.put(domain.getId(), domain);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RouterConfig) {
            RouterConfig _o = (RouterConfig)obj;
            return this.equals((Object)this.m_domain, (Object)_o.getDomain());
        }
        return false;
    }

    public Domain findDomain(String id) {
        return (Domain)this.m_domains.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain findOrCreateDomain(String id) {
        Domain domain = (Domain)this.m_domains.get(id);
        if (domain == null) {
            Map map = this.m_domains;
            synchronized (map) {
                domain = (Domain)this.m_domains.get(id);
                if (domain == null) {
                    domain = new Domain(id);
                    this.m_domains.put(id, domain);
                }
            }
        }
        return domain;
    }

    public String getBackupServer() {
        return this.m_backupServer;
    }

    public int getBackupServerPort() {
        return this.m_backupServerPort;
    }

    public List<DefaultServer> getDefaultServers() {
        return this.m_defaultServers;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public Map<String, Domain> getDomains() {
        return this.m_domains;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_domain == null ? 0 : this.m_domain.hashCode());
        return hash;
    }

    public void mergeAttributes(RouterConfig other) {
        this.assertAttributeEquals((Object)other, "router-config", "domain", (Object)this.m_domain, (Object)other.getDomain());
        if (other.getStartTime() != null) {
            this.m_startTime = other.getStartTime();
        }
        if (other.getBackupServer() != null) {
            this.m_backupServer = other.getBackupServer();
        }
        this.m_backupServerPort = other.getBackupServerPort();
        if (other.getEndTime() != null) {
            this.m_endTime = other.getEndTime();
        }
    }

    public Domain removeDomain(String id) {
        return (Domain)this.m_domains.remove(id);
    }

    public RouterConfig setBackupServer(String backupServer) {
        this.m_backupServer = backupServer;
        return this;
    }

    public RouterConfig setBackupServerPort(int backupServerPort) {
        this.m_backupServerPort = backupServerPort;
        return this;
    }

    public RouterConfig setDomain(String domain) {
        this.m_domain = domain;
        return this;
    }

    public RouterConfig setEndTime(Date endTime) {
        this.m_endTime = endTime;
        return this;
    }

    public RouterConfig setStartTime(Date startTime) {
        this.m_startTime = startTime;
        return this;
    }
}

