/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.transform;

import com.dianping.cat.home.router.IEntity;
import com.dianping.cat.home.router.IVisitor;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private RouterConfig m_routerConfig;

    public DefaultMerger() {
    }

    public DefaultMerger(RouterConfig routerConfig) {
        this.m_routerConfig = routerConfig;
        this.m_objs.push(routerConfig);
    }

    public RouterConfig getRouterConfig() {
        return this.m_routerConfig;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeDefaultServer(DefaultServer to, DefaultServer from) {
        to.mergeAttributes(from);
    }

    protected void mergeDomain(Domain to, Domain from) {
        to.mergeAttributes(from);
    }

    protected void mergeRouterConfig(RouterConfig to, RouterConfig from) {
        to.mergeAttributes(from);
    }

    protected void mergeServer(Server to, Server from) {
        to.mergeAttributes(from);
    }

    public void visitDefaultServer(DefaultServer from) {
        DefaultServer to = (DefaultServer)this.m_objs.peek();
        this.mergeDefaultServer(to, from);
        this.visitDefaultServerChildren(to, from);
    }

    protected void visitDefaultServerChildren(DefaultServer to, DefaultServer from) {
    }

    public void visitDomain(Domain from) {
        Domain to = (Domain)this.m_objs.peek();
        this.mergeDomain(to, from);
        this.visitDomainChildren(to, from);
    }

    protected void visitDomainChildren(Domain to, Domain from) {
        for (Server source : from.getServers()) {
            Server target = null;
            if (target == null) {
                target = new Server();
                to.addServer(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitRouterConfig(RouterConfig from) {
        RouterConfig to = (RouterConfig)this.m_objs.peek();
        this.mergeRouterConfig(to, from);
        this.visitRouterConfigChildren(to, from);
    }

    protected void visitRouterConfigChildren(RouterConfig to, RouterConfig from) {
        DefaultServer target;
        for (DefaultServer source : from.getDefaultServers()) {
            target = null;
            if (target == null) {
                target = new DefaultServer();
                to.addDefaultServer(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (DefaultServer source : from.getDomains().values()) {
            target = to.findDomain(source.getId());
            if (target == null) {
                target = new Domain(source.getId());
                to.addDomain((Domain)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitServer(Server from) {
        Server to = (Server)this.m_objs.peek();
        this.mergeServer(to, from);
        this.visitServerChildren(to, from);
    }

    protected void visitServerChildren(Server to, Server from) {
    }
}

