/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.transform;

import com.dianping.cat.home.router.IVisitor;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.transform.DefaultLinker;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeParser
implements IVisitor {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DataInputStream m_in;

    public DefaultNativeParser(InputStream in) {
        this.m_in = new DataInputStream(in);
    }

    public static RouterConfig parse(byte[] data) {
        return DefaultNativeParser.parse((InputStream)new ByteArrayInputStream(data));
    }

    public static RouterConfig parse(InputStream in) {
        RouterConfig routerConfig;
        DefaultNativeParser parser;
        block2: {
            parser = new DefaultNativeParser(in);
            routerConfig = new RouterConfig();
            try {
                routerConfig.accept((IVisitor)parser);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
        parser.m_linker.finish();
        return routerConfig;
    }

    public void visitDefaultServer(DefaultServer defaultServer) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitDefaultServerChildren(defaultServer, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitDefaultServerChildren(DefaultServer defaultServer, int _field, int _type) {
        switch (_field) {
            case 1: {
                defaultServer.setId(this.readString());
                break;
            }
            case 2: {
                defaultServer.setWeight(this.readDouble());
                break;
            }
            case 3: {
                defaultServer.setPort(this.readInt());
                break;
            }
            case 4: {
                defaultServer.setEnable(this.readBoolean());
            }
        }
    }

    public void visitDomain(Domain domain) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitDomainChildren(domain, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitDomainChildren(Domain domain, int _field, int _type) {
        switch (_field) {
            case 1: {
                domain.setId(this.readString());
                break;
            }
            case 2: {
                domain.setSample(this.readDouble());
                break;
            }
            case 33: {
                if (_type == 1) {
                    Server servers = new Server();
                    this.visitServer(servers);
                    this.m_linker.onServer(domain, servers);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Server servers = new Server();
                    this.visitServer(servers);
                    this.m_linker.onServer(domain, servers);
                }
                break;
            }
        }
    }

    public void visitRouterConfig(RouterConfig routerConfig) {
        byte tag = this.readTag();
        if (tag != -4) {
            throw new RuntimeException(String.format("Malformed payload, expected: %s, but was: %s!", -4, tag));
        }
        while ((tag = this.readTag()) != -1) {
            this.visitRouterConfigChildren(routerConfig, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitRouterConfigChildren(RouterConfig routerConfig, int _field, int _type) {
        switch (_field) {
            case 1: {
                routerConfig.setStartTime(this.readDate());
                break;
            }
            case 2: {
                routerConfig.setDomain(this.readString());
                break;
            }
            case 3: {
                routerConfig.setBackupServer(this.readString());
                break;
            }
            case 4: {
                routerConfig.setBackupServerPort(this.readInt());
                break;
            }
            case 5: {
                routerConfig.setEndTime(this.readDate());
                break;
            }
            case 33: {
                if (_type == 1) {
                    DefaultServer defaultServers = new DefaultServer();
                    this.visitDefaultServer(defaultServers);
                    this.m_linker.onDefaultServer(routerConfig, defaultServers);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    DefaultServer defaultServers = new DefaultServer();
                    this.visitDefaultServer(defaultServers);
                    this.m_linker.onDefaultServer(routerConfig, defaultServers);
                }
                break;
            }
            case 34: {
                if (_type == 1) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(routerConfig, domains);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(routerConfig, domains);
                }
                break;
            }
        }
    }

    public void visitServer(Server server) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitServerChildren(server, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitServerChildren(Server server, int _field, int _type) {
        switch (_field) {
            case 1: {
                server.setId(this.readString());
                break;
            }
            case 2: {
                server.setPort(this.readInt());
                break;
            }
            case 3: {
                server.setWeight(this.readDouble());
            }
        }
    }

    private boolean readBoolean() {
        try {
            return this.m_in.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Date readDate() {
        try {
            return new Date(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private double readDouble() {
        try {
            return Double.longBitsToDouble(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readInt() {
        try {
            return (int)this.readVarint(32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readString() {
        try {
            return this.m_in.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte readTag() {
        try {
            return this.m_in.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected long readVarint(int length) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < length; shift += 7) {
            byte b = this.m_in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("Malformed variable int " + length + "!");
    }
}

