/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.transform;

import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.transform.IMaker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxMaker
implements IMaker<Attributes> {
    public DefaultServer buildDefaultServer(Attributes attributes) {
        String id = attributes.getValue("id");
        String weight = attributes.getValue("weight");
        String port = attributes.getValue("port");
        String enable = attributes.getValue("enable");
        DefaultServer defaultServer = new DefaultServer();
        if (id != null) {
            defaultServer.setId(id);
        }
        if (weight != null) {
            defaultServer.setWeight(((Double)this.convert(Double.class, weight, (Object)0.0)).doubleValue());
        }
        if (port != null) {
            defaultServer.setPort(((Integer)this.convert(Integer.class, port, (Object)0)).intValue());
        }
        if (enable != null) {
            defaultServer.setEnable(((Boolean)this.convert(Boolean.class, enable, (Object)false)).booleanValue());
        }
        return defaultServer;
    }

    public Domain buildDomain(Attributes attributes) {
        String id = attributes.getValue("id");
        String sample = attributes.getValue("sample");
        Domain domain = new Domain(id);
        if (sample != null) {
            domain.setSample(((Double)this.convert(Double.class, sample, (Object)0.0)).doubleValue());
        }
        return domain;
    }

    public RouterConfig buildRouterConfig(Attributes attributes) {
        String startTime = attributes.getValue("startTime");
        String domain = attributes.getValue("domain");
        String backupServer = attributes.getValue("backup-server");
        String backupServerPort = attributes.getValue("backup-server-port");
        String endTime = attributes.getValue("endTime");
        RouterConfig routerConfig = new RouterConfig(domain);
        if (startTime != null) {
            routerConfig.setStartTime(this.toDate(startTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (backupServer != null) {
            routerConfig.setBackupServer(backupServer);
        }
        if (backupServerPort != null) {
            routerConfig.setBackupServerPort(((Integer)this.convert(Integer.class, backupServerPort, (Object)0)).intValue());
        }
        if (endTime != null) {
            routerConfig.setEndTime(this.toDate(endTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        return routerConfig;
    }

    public Server buildServer(Attributes attributes) {
        String id = attributes.getValue("id");
        String port = attributes.getValue("port");
        String weight = attributes.getValue("weight");
        Server server = new Server();
        if (id != null) {
            server.setId(id);
        }
        if (port != null) {
            server.setPort(((Integer)this.convert(Integer.class, port, (Object)0)).intValue());
        }
        if (weight != null) {
            server.setWeight(((Double)this.convert(Double.class, weight, (Object)0.0)).doubleValue());
        }
        return server;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected Date toDate(String str, String format, Date defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

