/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.transform;

import com.dianping.cat.home.router.IEntity;
import com.dianping.cat.home.router.IVisitor;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXmlBuilder
implements IVisitor {
    private IVisitor m_visitor = this;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultXmlBuilder() {
        this(false);
    }

    public DefaultXmlBuilder(boolean compact) {
        this(compact, new StringBuilder(4096));
    }

    public DefaultXmlBuilder(boolean compact, StringBuilder sb) {
        this.m_compact = compact;
        this.m_sb = sb;
        this.m_sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
    }

    public String buildXml(IEntity<?> entity) {
        entity.accept(this.m_visitor);
        return this.m_sb.toString();
    }

    protected void endTag(String name) {
        --this.m_level;
        this.indent();
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected String escape(Object value) {
        return this.escape(value, false);
    }

    protected String escape(Object value, boolean text) {
        if (value == null) {
            return null;
        }
        String str = value.toString();
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 16);
        block6: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (!text) {
                        sb.append("&quot;");
                        continue block6;
                    }
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void startTag(String name) {
        this.startTag(name, false, null, new Object[0]);
    }

    protected void startTag(String name, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, null, closed, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, null, false, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Object text, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                this.m_sb.append(' ').append(e.getKey()).append("=\"").append(this.escape((Object)e.getValue())).append('\"');
            }
        }
        if (text != null && closed) {
            this.m_sb.append('>');
            this.m_sb.append(this.escape(text, true));
            this.m_sb.append("</").append(name).append(">\r\n");
        } else {
            if (closed) {
                this.m_sb.append('/');
            } else {
                ++this.m_level;
            }
            this.m_sb.append(">\r\n");
        }
    }

    protected String toString(Date date, String format) {
        if (date != null) {
            return new SimpleDateFormat(format).format(date);
        }
        return null;
    }

    public void visitDefaultServer(DefaultServer defaultServer) {
        this.startTag("default-server", true, null, new Object[]{"id", defaultServer.getId(), "weight", defaultServer.getWeight(), "port", defaultServer.getPort(), "enable", defaultServer.isEnable()});
    }

    public void visitDomain(Domain domain) {
        this.startTag("domain", null, new Object[]{"id", domain.getId(), "sample", domain.getSample()});
        if (!domain.getServers().isEmpty()) {
            for (Server server : domain.getServers()) {
                server.accept(this.m_visitor);
            }
        }
        this.endTag("domain");
    }

    public void visitRouterConfig(RouterConfig routerConfig) {
        this.startTag("router-config", null, new Object[]{"startTime", this.toString(routerConfig.getStartTime(), "yyyy-MM-dd HH:mm:ss"), "domain", routerConfig.getDomain(), "backup-server", routerConfig.getBackupServer(), "backup-server-port", routerConfig.getBackupServerPort(), "endTime", this.toString(routerConfig.getEndTime(), "yyyy-MM-dd HH:mm:ss")});
        if (!routerConfig.getDefaultServers().isEmpty()) {
            for (DefaultServer defaultServer : routerConfig.getDefaultServers()) {
                defaultServer.accept(this.m_visitor);
            }
        }
        if (!routerConfig.getDomains().isEmpty()) {
            for (Domain domain : routerConfig.getDomains().values()) {
                domain.accept(this.m_visitor);
            }
        }
        this.endTag("router-config");
    }

    public void visitServer(Server server) {
        this.startTag("server", true, null, new Object[]{"id", server.getId(), "port", server.getPort(), "weight", server.getWeight()});
    }
}

