/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.rule.transform;

import com.dianping.cat.home.rule.IEntity;
import com.dianping.cat.home.rule.entity.Condition;
import com.dianping.cat.home.rule.entity.Config;
import com.dianping.cat.home.rule.entity.MetricItem;
import com.dianping.cat.home.rule.entity.MonitorRules;
import com.dianping.cat.home.rule.entity.Rule;
import com.dianping.cat.home.rule.entity.SubCondition;
import com.dianping.cat.home.rule.transform.DefaultJsonParser;
import com.dianping.cat.home.rule.transform.DefaultLinker;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DefaultJsonParser {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private List<Object> m_entities = new ArrayList();
    private Class<?> m_entityClass;

    private DefaultJsonParser(Class<?> entityClass) {
        this.m_entityClass = entityClass;
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, InputStream in) throws IOException {
        return (T)DefaultJsonParser.parse(entityClass, (Reader)new InputStreamReader(in, "utf-8"));
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, Reader reader) throws IOException {
        DefaultJsonParser parser = new DefaultJsonParser(entityClass);
        parser.onArrayBegin();
        parser.parse(new JsonReader(reader));
        parser.onArrayEnd();
        if (parser.m_entities.isEmpty()) {
            return null;
        }
        return (T)((IEntity)parser.m_entities.get(0));
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, String json) throws IOException {
        return (T)DefaultJsonParser.parse(entityClass, (Reader)new StringReader(json));
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, InputStream in) throws Exception {
        return DefaultJsonParser.parseArray(entityClass, (Reader)new InputStreamReader(in, "utf-8"));
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, Reader reader) throws Exception {
        DefaultJsonParser parser = new DefaultJsonParser(entityClass);
        parser.parse(new JsonReader(reader));
        return parser.m_entities;
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, String json) throws Exception {
        return DefaultJsonParser.parseArray(entityClass, (Reader)new StringReader(json));
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    private Object createRootEntity() {
        try {
            Object entity = this.m_entityClass.newInstance();
            return entity;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to create entity(%s) instance!", this.m_entityClass.getName()), e);
        }
    }

    private boolean isTopLevel() {
        return this.m_objs.size() == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onArrayBegin() {
        if (this.m_objs.isEmpty()) {
            this.m_objs.push(this.m_entities);
            this.m_tags.push("");
            return;
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof Rule) {
                if ("metric-items".equals(tag)) {
                    this.m_objs.push(parent);
                    return;
                } else {
                    if (!"configs".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                    this.m_objs.push(parent);
                }
                return;
            } else if (parent instanceof Config) {
                if (!"conditions".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                this.m_objs.push(parent);
                return;
            } else {
                if (!(parent instanceof Condition)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                if (!"sub-conditions".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                this.m_objs.push(parent);
            }
        }
    }

    protected void onArrayEnd() {
        this.m_objs.pop();
        this.m_tags.pop();
    }

    protected void onName(String name) {
        this.m_tags.push(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onObjectBegin() {
        if (this.isTopLevel()) {
            this.m_objs.push(this.createRootEntity());
            this.m_tags.push("");
            return;
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof MonitorRules) {
                if ("rules".equals(tag)) {
                    this.m_objs.push(parent);
                    return;
                } else {
                    String parentTag;
                    String string = parentTag = this.m_tags.size() >= 2 ? (String)this.m_tags.get(this.m_tags.size() - 2) : null;
                    if (!"rules".equals(parentTag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                    Rule rules = new Rule();
                    this.m_linker.onRule((MonitorRules)parent, rules);
                    this.m_objs.push(rules);
                }
                return;
            } else if (parent instanceof Rule) {
                if ("metric-items".equals(tag)) {
                    MetricItem metricItems = new MetricItem();
                    this.m_linker.onMetricItem((Rule)parent, metricItems);
                    this.m_objs.push(metricItems);
                    this.m_tags.push("");
                    return;
                } else {
                    if (!"configs".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                    Config configs = new Config();
                    this.m_linker.onConfig((Rule)parent, configs);
                    this.m_objs.push(configs);
                    this.m_tags.push("");
                }
                return;
            } else if (parent instanceof Config) {
                if (!"conditions".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                Condition conditions = new Condition();
                this.m_linker.onCondition((Config)parent, conditions);
                this.m_objs.push(conditions);
                this.m_tags.push("");
                return;
            } else {
                if (!(parent instanceof Condition)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                if (!"sub-conditions".equals(tag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                SubCondition subConditions = new SubCondition();
                this.m_linker.onSubCondition((Condition)parent, subConditions);
                this.m_objs.push(subConditions);
                this.m_tags.push("");
            }
        }
    }

    protected void onObjectEnd() {
        this.m_tags.pop();
        Object entity = this.m_objs.pop();
        if (this.isTopLevel()) {
            this.m_entities.add(entity);
        }
    }

    protected void onValue(String value) {
        Object parent = this.m_objs.peek();
        String tag = (String)this.m_tags.pop();
        if (parent instanceof MonitorRules) {
            this.parseForMonitorRules((MonitorRules)parent, tag, value);
        } else if (parent instanceof Rule) {
            this.parseForRule((Rule)parent, tag, value);
        } else if (parent instanceof MetricItem) {
            this.parseForMetricItem((MetricItem)parent, tag, value);
        } else if (parent instanceof Config) {
            this.parseForConfig((Config)parent, tag, value);
        } else if (parent instanceof Condition) {
            this.parseForCondition((Condition)parent, tag, value);
        } else if (parent instanceof SubCondition) {
            this.parseForSubCondition((SubCondition)parent, tag, value);
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) under %s!", tag, parent));
        }
    }

    private void parse(JsonReader reader) throws IOException {
        block2: {
            try {
                reader.parse(this);
            }
            catch (EOFException e) {
                if (this.m_objs.size() <= 1) break block2;
                throw new EOFException(String.format("Unexpected end while parsing json! tags: %s.", this.m_tags));
            }
        }
        this.m_linker.finish();
    }

    public void parseForCondition(Condition condition, String tag, String value) {
        if (!"sub-conditions".equals(tag)) {
            if ("minute".equals(tag)) {
                condition.setMinute((Integer)this.convert(Integer.class, value, null));
            } else if ("title".equals(tag)) {
                condition.setTitle(value);
            } else if ("alertType".equals(tag)) {
                condition.setAlertType(value);
            } else {
                throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, condition, this.m_tags));
            }
        }
    }

    public void parseForConfig(Config config, String tag, String value) {
        if (!"conditions".equals(tag)) {
            if ("starttime".equals(tag)) {
                config.setStarttime(value);
            } else if ("endtime".equals(tag)) {
                config.setEndtime(value);
            } else {
                throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, config, this.m_tags));
            }
        }
    }

    public void parseForMetricItem(MetricItem metricItem, String tag, String value) {
        if ("monitorCount".equals(tag)) {
            metricItem.setMonitorCount((Boolean)this.convert(Boolean.class, value, null));
        } else if ("monitorSum".equals(tag)) {
            metricItem.setMonitorSum((Boolean)this.convert(Boolean.class, value, null));
        } else if ("monitorAvg".equals(tag)) {
            metricItem.setMonitorAvg((Boolean)this.convert(Boolean.class, value, null));
        } else if ("productText".equals(tag)) {
            metricItem.setProductText(value);
        } else if ("metricItemText".equals(tag)) {
            metricItem.setMetricItemText(value);
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, metricItem, this.m_tags));
        }
    }

    public void parseForMonitorRules(MonitorRules monitorRules, String tag, String value) {
        if (!"rules".equals(tag)) {
            throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, monitorRules, this.m_tags));
        }
    }

    public void parseForRule(Rule rule, String tag, String value) {
        if (!"metric-items".equals(tag) && !"configs".equals(tag)) {
            if ("id".equals(tag)) {
                rule.setId(value);
            } else {
                throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, rule, this.m_tags));
            }
        }
    }

    public void parseForSubCondition(SubCondition subCondition, String tag, String value) {
        if ("type".equals(tag)) {
            subCondition.setType(value);
        } else if ("text".equals(tag)) {
            subCondition.setText(value);
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, subCondition, this.m_tags));
        }
    }
}

