/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.rule.transform;

import com.dianping.cat.home.rule.IEntity;
import com.dianping.cat.home.rule.entity.Condition;
import com.dianping.cat.home.rule.entity.Config;
import com.dianping.cat.home.rule.entity.MetricItem;
import com.dianping.cat.home.rule.entity.MonitorRules;
import com.dianping.cat.home.rule.entity.Rule;
import com.dianping.cat.home.rule.entity.SubCondition;
import com.dianping.cat.home.rule.transform.DefaultLinker;
import com.dianping.cat.home.rule.transform.DefaultSaxMaker;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static MonitorRules parse(InputSource is) throws SAXException, IOException {
        return (MonitorRules)DefaultSaxParser.parseEntity(MonitorRules.class, (InputSource)is);
    }

    public static MonitorRules parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(in));
    }

    public static MonitorRules parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(reader));
    }

    public static MonitorRules parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse((InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            this.m_objs.pop();
            this.m_tags.pop();
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForCondition(Condition parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"sub-condition".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under condition!", qName));
        }
        SubCondition subCondition = this.m_maker.buildSubCondition(attributes);
        this.m_linker.onSubCondition(parentObj, subCondition);
        this.m_objs.push(subCondition);
        this.m_tags.push(qName);
    }

    private void parseForConfig(Config parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"condition".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under config!", qName));
        }
        Condition condition = this.m_maker.buildCondition(attributes);
        this.m_linker.onCondition(parentObj, condition);
        this.m_objs.push(condition);
        this.m_tags.push(qName);
    }

    private void parseForMetricItem(MetricItem parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForMonitorRules(MonitorRules parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"rule".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under monitor-rules!", qName));
        }
        Rule rule = this.m_maker.buildRule(attributes);
        this.m_linker.onRule(parentObj, rule);
        this.m_objs.push(rule);
        this.m_tags.push(qName);
    }

    private void parseForRule(Rule parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("metric-item".equals(qName)) {
            MetricItem metricItem = this.m_maker.buildMetricItem(attributes);
            this.m_linker.onMetricItem(parentObj, metricItem);
            this.m_objs.push(metricItem);
        } else if ("config".equals(qName)) {
            Config config = this.m_maker.buildConfig(attributes);
            this.m_linker.onConfig(parentObj, config);
            this.m_objs.push(config);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under rule!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForSubCondition(SubCondition parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("monitor-rules".equals(qName)) {
            MonitorRules monitorRules = this.m_maker.buildMonitorRules(attributes);
            this.m_entity = monitorRules;
            this.m_objs.push(monitorRules);
            this.m_tags.push(qName);
        } else if ("rule".equals(qName)) {
            Rule rule = this.m_maker.buildRule(attributes);
            this.m_entity = rule;
            this.m_objs.push(rule);
            this.m_tags.push(qName);
        } else if ("metric-item".equals(qName)) {
            MetricItem metricItem = this.m_maker.buildMetricItem(attributes);
            this.m_entity = metricItem;
            this.m_objs.push(metricItem);
            this.m_tags.push(qName);
        } else if ("config".equals(qName)) {
            Config config = this.m_maker.buildConfig(attributes);
            this.m_entity = config;
            this.m_objs.push(config);
            this.m_tags.push(qName);
        } else if ("condition".equals(qName)) {
            Condition condition = this.m_maker.buildCondition(attributes);
            this.m_entity = condition;
            this.m_objs.push(condition);
            this.m_tags.push(qName);
        } else if ("sub-condition".equals(qName)) {
            SubCondition subCondition = this.m_maker.buildSubCondition(attributes);
            this.m_entity = subCondition;
            this.m_objs.push(subCondition);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof MonitorRules) {
                this.parseForMonitorRules((MonitorRules)parent, tag, qName, attributes);
            } else if (parent instanceof Rule) {
                this.parseForRule((Rule)parent, tag, qName, attributes);
            } else if (parent instanceof MetricItem) {
                this.parseForMetricItem((MetricItem)parent, tag, qName, attributes);
            } else if (parent instanceof Config) {
                this.parseForConfig((Config)parent, tag, qName, attributes);
            } else if (parent instanceof Condition) {
                this.parseForCondition((Condition)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof SubCondition)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForSubCondition((SubCondition)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

