/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.service.transform;

import com.dianping.cat.home.service.IVisitor;
import com.dianping.cat.home.service.entity.Domain;
import com.dianping.cat.home.service.entity.ServiceReport;
import com.dianping.cat.home.service.transform.DefaultLinker;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeParser
implements IVisitor {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DataInputStream m_in;

    public DefaultNativeParser(InputStream in) {
        this.m_in = new DataInputStream(in);
    }

    public static ServiceReport parse(byte[] data) {
        return DefaultNativeParser.parse((InputStream)new ByteArrayInputStream(data));
    }

    public static ServiceReport parse(InputStream in) {
        ServiceReport serviceReport;
        DefaultNativeParser parser;
        block2: {
            parser = new DefaultNativeParser(in);
            serviceReport = new ServiceReport();
            try {
                serviceReport.accept((IVisitor)parser);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
        parser.m_linker.finish();
        return serviceReport;
    }

    public void visitDomain(Domain domain) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitDomainChildren(domain, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitDomainChildren(Domain domain, int _field, int _type) {
        switch (_field) {
            case 1: {
                domain.setId(this.readString());
                break;
            }
            case 2: {
                domain.setTotalCount(this.readLong());
                break;
            }
            case 3: {
                domain.setFailureCount(this.readLong());
                break;
            }
            case 4: {
                domain.setFailurePercent(this.readDouble());
                break;
            }
            case 5: {
                domain.setSum(this.readDouble());
                break;
            }
            case 6: {
                domain.setAvg(this.readDouble());
                break;
            }
            case 7: {
                domain.setQps(this.readDouble());
            }
        }
    }

    public void visitServiceReport(ServiceReport serviceReport) {
        byte tag = this.readTag();
        if (tag != -4) {
            throw new RuntimeException(String.format("Malformed payload, expected: %s, but was: %s!", -4, tag));
        }
        while ((tag = this.readTag()) != -1) {
            this.visitServiceReportChildren(serviceReport, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitServiceReportChildren(ServiceReport serviceReport, int _field, int _type) {
        switch (_field) {
            case 1: {
                serviceReport.setStartTime(this.readDate());
                break;
            }
            case 2: {
                serviceReport.setDomain(this.readString());
                break;
            }
            case 3: {
                serviceReport.setEndTime(this.readDate());
                break;
            }
            case 33: {
                if (_type == 1) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(serviceReport, domains);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Domain domains = new Domain();
                    this.visitDomain(domains);
                    this.m_linker.onDomain(serviceReport, domains);
                }
                break;
            }
        }
    }

    private Date readDate() {
        try {
            return new Date(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private double readDouble() {
        try {
            return Double.longBitsToDouble(this.readVarint(64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readInt() {
        try {
            return (int)this.readVarint(32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long readLong() {
        try {
            return this.readVarint(64);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readString() {
        try {
            return this.m_in.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte readTag() {
        try {
            return this.m_in.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected long readVarint(int length) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < length; shift += 7) {
            byte b = this.m_in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("Malformed variable int " + length + "!");
    }
}

