/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.storage.alert.entity;

import com.dianping.cat.home.storage.alert.BaseEntity;
import com.dianping.cat.home.storage.alert.IVisitor;
import com.dianping.cat.home.storage.alert.entity.Machine;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storage
extends BaseEntity<Storage> {
    private String m_id;
    private int m_level;
    private int m_count;
    private Map<String, Machine> m_machines = new LinkedHashMap();

    public Storage() {
    }

    public Storage(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitStorage(this);
    }

    public Storage addMachine(Machine machine) {
        this.m_machines.put(machine.getId(), machine);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Storage) {
            Storage _o = (Storage)obj;
            return this.equals((Object)this.m_id, (Object)_o.getId());
        }
        return false;
    }

    public Machine findMachine(String id) {
        return (Machine)this.m_machines.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Machine findOrCreateMachine(String id) {
        Machine machine = (Machine)this.m_machines.get(id);
        if (machine == null) {
            Map map = this.m_machines;
            synchronized (map) {
                machine = (Machine)this.m_machines.get(id);
                if (machine == null) {
                    machine = new Machine(id);
                    this.m_machines.put(id, machine);
                }
            }
        }
        return machine;
    }

    public int getCount() {
        return this.m_count;
    }

    public String getId() {
        return this.m_id;
    }

    public int getLevel() {
        return this.m_level;
    }

    public Map<String, Machine> getMachines() {
        return this.m_machines;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public Storage incCount() {
        ++this.m_count;
        return this;
    }

    public Storage incCount(int count) {
        this.m_count += count;
        return this;
    }

    public void mergeAttributes(Storage other) {
        this.assertAttributeEquals((Object)other, "storage", "id", (Object)this.m_id, (Object)other.getId());
        this.m_level = other.getLevel();
        this.m_count = other.getCount();
    }

    public Machine removeMachine(String id) {
        return (Machine)this.m_machines.remove(id);
    }

    public Storage setCount(int count) {
        this.m_count = count;
        return this;
    }

    public Storage setId(String id) {
        this.m_id = id;
        return this;
    }

    public Storage setLevel(int level) {
        this.m_level = level;
        return this;
    }
}

