/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.storage.entity;

import com.dianping.cat.home.storage.BaseEntity;
import com.dianping.cat.home.storage.IVisitor;
import com.dianping.cat.home.storage.entity.Machine;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storage
extends BaseEntity<Storage> {
    private String m_id;
    private String m_department;
    private String m_productline;
    private String m_title;
    private Map<String, Machine> m_machines = new LinkedHashMap();

    public Storage() {
    }

    public Storage(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitStorage(this);
    }

    public Storage addMachine(Machine machine) {
        this.m_machines.put(machine.getId(), machine);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Storage) {
            Storage _o = (Storage)obj;
            return this.equals((Object)this.m_id, (Object)_o.getId());
        }
        return false;
    }

    public Machine findMachine(String id) {
        return (Machine)this.m_machines.get(id);
    }

    public String getDepartment() {
        return this.m_department;
    }

    public String getId() {
        return this.m_id;
    }

    public Map<String, Machine> getMachines() {
        return this.m_machines;
    }

    public String getProductline() {
        return this.m_productline;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Storage other) {
        this.assertAttributeEquals((Object)other, "storage", "id", (Object)this.m_id, (Object)other.getId());
        if (other.getDepartment() != null) {
            this.m_department = other.getDepartment();
        }
        if (other.getProductline() != null) {
            this.m_productline = other.getProductline();
        }
        if (other.getTitle() != null) {
            this.m_title = other.getTitle();
        }
    }

    public Machine removeMachine(String id) {
        return (Machine)this.m_machines.remove(id);
    }

    public Storage setDepartment(String department) {
        this.m_department = department;
        return this;
    }

    public Storage setId(String id) {
        this.m_id = id;
        return this;
    }

    public Storage setProductline(String productline) {
        this.m_productline = productline;
        return this;
    }

    public Storage setTitle(String title) {
        this.m_title = title;
        return this;
    }
}

