/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.storage.entity;

import com.dianping.cat.home.storage.BaseEntity;
import com.dianping.cat.home.storage.IVisitor;
import com.dianping.cat.home.storage.entity.Link;
import com.dianping.cat.home.storage.entity.Storage;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageGroup
extends BaseEntity<StorageGroup> {
    private String m_id;
    private Link m_link;
    private Map<String, Storage> m_storages = new LinkedHashMap();

    public StorageGroup() {
    }

    public StorageGroup(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitStorageGroup(this);
    }

    public StorageGroup addStorage(Storage storage) {
        this.m_storages.put(storage.getId(), storage);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageGroup) {
            StorageGroup _o = (StorageGroup)obj;
            return this.equals((Object)this.m_id, (Object)_o.getId());
        }
        return false;
    }

    public Storage findStorage(String id) {
        return (Storage)this.m_storages.get(id);
    }

    public String getId() {
        return this.m_id;
    }

    public Link getLink() {
        return this.m_link;
    }

    public Map<String, Storage> getStorages() {
        return this.m_storages;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(StorageGroup other) {
        this.assertAttributeEquals((Object)other, "storage-group", "id", (Object)this.m_id, (Object)other.getId());
    }

    public Storage removeStorage(String id) {
        return (Storage)this.m_storages.remove(id);
    }

    public StorageGroup setId(String id) {
        this.m_id = id;
        return this;
    }

    public StorageGroup setLink(Link link) {
        this.m_link = link;
        return this;
    }
}

